/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.client.spring;

import io.rsocket.RSocket;
import io.rsocket.broker.client.spring.BrokerClientProperties;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Key;
import io.rsocket.broker.common.WellKnownKey;
import io.rsocket.broker.common.spring.MimeTypes;
import io.rsocket.broker.frames.Address;
import io.rsocket.core.RSocketClient;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.RouteMatcher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BrokerRSocketRequester
implements RSocketRequester {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private final RSocketRequester delegate;
    private final BrokerClientProperties properties;
    private final RouteMatcher routeMatcher;

    BrokerRSocketRequester(RSocketRequester delegate, BrokerClientProperties properties, RouteMatcher routeMatcher) {
        this.delegate = delegate;
        this.properties = properties;
        this.routeMatcher = routeMatcher;
    }

    public RSocket rsocket() {
        return this.delegate.rsocket();
    }

    public RSocketClient rsocketClient() {
        return this.delegate.rsocketClient();
    }

    public MimeType dataMimeType() {
        return this.delegate.dataMimeType();
    }

    public MimeType metadataMimeType() {
        return this.delegate.metadataMimeType();
    }

    public BrokerRequestSpec route(String route, Object ... routeVars) {
        String expandedRoute = BrokerRSocketRequester.expand(route, routeVars);
        BrokerRequestSpec requestSpec = new BrokerRequestSpec(this.delegate.route(route, routeVars), this.properties.isFailIfMissingBrokerMetadata(), expandedRoute);
        RouteMatcher.Route parsed = this.routeMatcher.parseRoute(expandedRoute);
        this.properties.getAddress().entrySet().stream().filter(entry -> this.routeMatcher.match((String)entry.getKey(), parsed)).findFirst().ifPresent(entry -> {
            Map tags = (Map)entry.getValue();
            Address.Builder address = BrokerRSocketRequester.address(this.routeMatcher, parsed, this.properties.getRouteId(), (String)entry.getKey(), tags);
            requestSpec.metadata(address.build(), MimeTypes.BROKER_FRAME_MIME_TYPE);
        });
        return requestSpec;
    }

    static Address.Builder address(RouteMatcher routeMatcher, RouteMatcher.Route route, Id originRouteId, String routeKey, Map<? extends Key, String> tags) {
        Map extracted = routeMatcher.matchAndExtract(routeKey, route);
        Address.Builder address = Address.from((Id)originRouteId);
        tags.forEach((tagKey, value) -> {
            if (tagKey.getWellKnownKey() != null) {
                address.with(tagKey.getWellKnownKey(), BrokerRSocketRequester.expand(value, extracted));
            } else if (tagKey.getKey() != null) {
                address.with(tagKey.getKey(), BrokerRSocketRequester.expand(value, extracted));
            }
        });
        return address;
    }

    public BrokerRequestSpec metadata(Object metadata, MimeType mimeType) {
        return new BrokerRequestSpec(this.delegate.metadata(metadata, mimeType), this.properties.isFailIfMissingBrokerMetadata(), "unknown route");
    }

    static String expand(String route, Object ... routeVars) {
        if (ObjectUtils.isEmpty((Object[])routeVars)) {
            return route;
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        Matcher matcher = NAMES_PATTERN.matcher(route);
        while (matcher.find()) {
            Assert.isTrue((index < routeVars.length ? 1 : 0) != 0, () -> "No value for variable '" + matcher.group(1) + "'");
            String value = routeVars[index].toString();
            value = value.contains(".") ? value.replaceAll("\\.", "%2E") : value;
            matcher.appendReplacement(sb, value);
            ++index;
        }
        return sb.toString();
    }

    static String expand(String template, Map<String, ?> vars) {
        if (template == null) {
            return null;
        }
        if (template.indexOf(123) == -1) {
            return template;
        }
        if (template.indexOf(58) != -1) {
            template = BrokerRSocketRequester.sanitizeSource(template);
        }
        if (ObjectUtils.isEmpty(vars)) {
            return template;
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = NAMES_PATTERN.matcher(template);
        while (matcher.find()) {
            String match = matcher.group(1);
            String varName = BrokerRSocketRequester.getVariableName(match);
            Object varValue = vars.get(varName);
            String formatted = BrokerRSocketRequester.getVariableValueAsString(varValue);
            matcher.appendReplacement(sb, formatted);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String sanitizeSource(String source) {
        int level = 0;
        StringBuilder sb = new StringBuilder();
        for (char c : source.toCharArray()) {
            if (c == '{') {
                ++level;
            }
            if (c == '}') {
                --level;
            }
            if (level > 1 || level == 1 && c == '}') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static String getVariableName(String match) {
        int colonIdx = match.indexOf(58);
        return colonIdx != -1 ? match.substring(0, colonIdx) : match;
    }

    private static String getVariableValueAsString(@Nullable Object variableValue) {
        return variableValue != null ? variableValue.toString() : "";
    }

    public class BrokerRequestSpec
    implements RSocketRequester.RequestSpec {
        private final RSocketRequester.RequestSpec delegate;
        private final boolean failIfMissingBrokerMetadata;
        private final String route;
        private boolean hasBrokerMetadata;

        public BrokerRequestSpec(RSocketRequester.RequestSpec delegate, boolean failIfMissingBrokerMetadata, String route) {
            this.delegate = delegate;
            this.failIfMissingBrokerMetadata = failIfMissingBrokerMetadata;
            this.route = route;
        }

        public BrokerRequestSpec address(String serviceName) {
            this.metadata((T spec) -> {
                Address address = ((Address.Builder)Address.from((Id)BrokerRSocketRequester.this.properties.getRouteId()).with(WellKnownKey.SERVICE_NAME, serviceName)).build();
                spec.metadata((Object)address, MimeTypes.BROKER_FRAME_MIME_TYPE);
            });
            return this;
        }

        public BrokerRequestSpec address(Consumer<Address.Builder> builderConsumer) {
            this.metadata((T spec) -> {
                Address.Builder builder = Address.from((Id)BrokerRSocketRequester.this.properties.getRouteId());
                builderConsumer.accept(builder);
                spec.metadata((Object)builder.build(), MimeTypes.BROKER_FRAME_MIME_TYPE);
            });
            return this;
        }

        public BrokerRequestSpec metadata(Consumer<RSocketRequester.MetadataSpec<?>> configurer) {
            configurer.accept((RSocketRequester.MetadataSpec<?>)this);
            return this;
        }

        public Mono<Void> sendMetadata() {
            this.validateMetadataSet();
            return this.delegate.sendMetadata();
        }

        public RSocketRequester.RetrieveSpec data(Object data) {
            this.delegate.data(data);
            return this;
        }

        public RSocketRequester.RetrieveSpec data(Object producer, Class<?> elementClass) {
            this.delegate.data(producer, elementClass);
            return this;
        }

        public RSocketRequester.RetrieveSpec data(Object producer, ParameterizedTypeReference<?> elementTypeRef) {
            this.delegate.data(producer, elementTypeRef);
            return this;
        }

        public BrokerRequestSpec metadata(Object metadata, MimeType mimeType) {
            if (mimeType.equals((Object)MimeTypes.BROKER_FRAME_MIME_TYPE)) {
                this.hasBrokerMetadata = true;
            }
            this.delegate.metadata(metadata, mimeType);
            return this;
        }

        public Mono<Void> send() {
            this.validateMetadataSet();
            return this.delegate.send();
        }

        public <T> Mono<T> retrieveMono(Class<T> dataType) {
            this.validateMetadataSet();
            return this.delegate.retrieveMono(dataType);
        }

        public <T> Mono<T> retrieveMono(ParameterizedTypeReference<T> dataTypeRef) {
            this.validateMetadataSet();
            return this.delegate.retrieveMono(dataTypeRef);
        }

        public <T> Flux<T> retrieveFlux(Class<T> dataType) {
            this.validateMetadataSet();
            return this.delegate.retrieveFlux(dataType);
        }

        public <T> Flux<T> retrieveFlux(ParameterizedTypeReference<T> dataTypeRef) {
            this.validateMetadataSet();
            return this.delegate.retrieveFlux(dataTypeRef);
        }

        private void validateMetadataSet() {
            if (this.failIfMissingBrokerMetadata && !this.hasBrokerMetadata) {
                throw new IllegalArgumentException(MimeTypes.BROKER_FRAME_MIME_TYPE + " metadata was not set for route: " + this.route);
            }
        }
    }
}

