/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.client.spring;

import io.rsocket.broker.client.spring.BrokerClientProperties;
import io.rsocket.broker.client.spring.BrokerRSocketRequester;
import io.rsocket.loadbalance.LoadbalanceStrategy;
import io.rsocket.loadbalance.LoadbalanceTarget;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.messaging.rsocket.RSocketConnectorConfigurer;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.MimeType;
import org.springframework.util.RouteMatcher;
import reactor.core.publisher.Mono;

public class BrokerRSocketRequesterBuilder
implements RSocketRequester.Builder {
    private final RSocketRequester.Builder delegate;
    private final BrokerClientProperties properties;
    private final RouteMatcher routeMatcher;

    BrokerRSocketRequesterBuilder(RSocketRequester.Builder delegate, BrokerClientProperties properties, RouteMatcher routeMatcher) {
        this.delegate = delegate;
        this.properties = properties;
        this.routeMatcher = routeMatcher;
    }

    public RSocketRequester.Builder rsocketConnector(RSocketConnectorConfigurer configurer) {
        return this.delegate.rsocketConnector(configurer);
    }

    public RSocketRequester.Builder dataMimeType(MimeType mimeType) {
        return this.delegate.dataMimeType(mimeType);
    }

    public RSocketRequester.Builder metadataMimeType(MimeType mimeType) {
        return this.delegate.metadataMimeType(mimeType);
    }

    public RSocketRequester.Builder setupData(Object data) {
        return this.delegate.setupData(data);
    }

    public RSocketRequester.Builder setupRoute(String route, Object ... routeVars) {
        return this.delegate.setupRoute(route, routeVars);
    }

    public RSocketRequester.Builder setupMetadata(Object value, MimeType mimeType) {
        return this.delegate.setupMetadata(value, mimeType);
    }

    public RSocketRequester.Builder rsocketStrategies(RSocketStrategies strategies) {
        return this.delegate.rsocketStrategies(strategies);
    }

    public RSocketRequester.Builder rsocketStrategies(Consumer<RSocketStrategies.Builder> configurer) {
        return this.delegate.rsocketStrategies(configurer);
    }

    public BrokerRSocketRequester tcp(String host, int port) {
        return this.wrap(this.delegate.tcp(host, port));
    }

    public BrokerRSocketRequester websocket(URI uri) {
        return this.wrap(this.delegate.websocket(uri));
    }

    public BrokerRSocketRequester transport(ClientTransport transport) {
        return this.wrap(this.delegate.transport(transport));
    }

    public RSocketRequester.Builder apply(Consumer<RSocketRequester.Builder> configurer) {
        return this.delegate.apply(configurer);
    }

    public BrokerRSocketRequester transports(Publisher<List<LoadbalanceTarget>> targetPublisher, LoadbalanceStrategy loadbalanceStrategy) {
        return this.wrap(this.delegate.transports(targetPublisher, loadbalanceStrategy));
    }

    @Deprecated
    public Mono<RSocketRequester> connectTcp(String host, int port) {
        return this.connect((ClientTransport)TcpClientTransport.create((String)host, (int)port));
    }

    @Deprecated
    public Mono<RSocketRequester> connectWebSocket(URI uri) {
        return this.connect((ClientTransport)WebsocketClientTransport.create((URI)uri));
    }

    @Deprecated
    public Mono<RSocketRequester> connect(ClientTransport transport) {
        return this.delegate.connect(transport).map(this::wrap);
    }

    private BrokerRSocketRequester wrap(RSocketRequester requester) {
        return new BrokerRSocketRequester(requester, this.properties, this.routeMatcher);
    }
}

