/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.broker.client.BrokerRSocketConnector;
import io.rsocket.broker.client.Route;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.common.WellKnownKey;
import io.rsocket.broker.frames.Address;
import io.rsocket.broker.frames.AddressFlyweight;
import io.rsocket.core.RSocketClient;
import io.rsocket.metadata.CompositeMetadataCodec;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BrokerRSocketClient
implements RSocketClient,
Route {
    private final BrokerRSocketConnector connector;
    private final RSocketClient delegate;

    public BrokerRSocketClient(BrokerRSocketConnector connector, RSocketClient delegate) {
        this.connector = connector;
        this.delegate = delegate;
    }

    @Override
    public void encodeAddressMetadata(CompositeByteBuf metadataHolder, String serviceName) {
        Address.Builder builder = (Address.Builder)Address.from((Id)this.connector.getRouteId()).with(WellKnownKey.SERVICE_NAME, serviceName);
        this.encodeAndAddMetadata(metadataHolder, builder.build());
    }

    @Override
    public void encodeAddressMetadata(CompositeByteBuf metadataHolder, Consumer<Address.Builder> addressConsumer) {
        Address.Builder builder = Address.from((Id)this.connector.getRouteId());
        addressConsumer.accept(builder);
        this.encodeAndAddMetadata(metadataHolder, builder.build());
    }

    @Override
    public ByteBufAllocator allocator() {
        return this.connector.getAllocator();
    }

    private void encodeAndAddMetadata(CompositeByteBuf composite, Address address) {
        ByteBuf byteBuf = AddressFlyweight.encode((ByteBufAllocator)this.connector.getAllocator(), (Id)address.getOriginRouteId(), (Tags)address.getMetadata(), (Tags)address.getTags(), (int)address.getFlags());
        CompositeMetadataCodec.encodeAndAddMetadata((CompositeByteBuf)composite, (ByteBufAllocator)this.connector.getAllocator(), (String)"message/x.rsocket.broker.frame.v0", (ByteBuf)byteBuf);
    }

    public Mono<RSocket> source() {
        return this.delegate.source();
    }

    public Mono<Void> fireAndForget(Mono<Payload> payloadMono) {
        return this.delegate.fireAndForget(payloadMono);
    }

    public Mono<Payload> requestResponse(Mono<Payload> payloadMono) {
        return this.delegate.requestResponse(payloadMono);
    }

    public Flux<Payload> requestStream(Mono<Payload> payloadMono) {
        return this.delegate.requestStream(payloadMono);
    }

    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.delegate.requestChannel(payloads);
    }

    public Mono<Void> metadataPush(Mono<Payload> payloadMono) {
        return this.delegate.metadataPush(payloadMono);
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public boolean isDisposed() {
        return this.delegate.isDisposed();
    }
}

