/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.common.spring;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.common.spring.MimeTypes;
import io.rsocket.broker.frames.Address;
import io.rsocket.broker.frames.AddressFlyweight;
import io.rsocket.broker.frames.BrokerFrame;
import io.rsocket.broker.frames.BrokerInfo;
import io.rsocket.broker.frames.BrokerInfoFlyweight;
import io.rsocket.broker.frames.RouteJoin;
import io.rsocket.broker.frames.RouteJoinFlyweight;
import io.rsocket.broker.frames.RouteRemove;
import io.rsocket.broker.frames.RouteRemoveFlyweight;
import io.rsocket.broker.frames.RouteSetup;
import io.rsocket.broker.frames.RouteSetupFlyweight;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;

public class BrokerFrameEncoder
extends AbstractEncoder<BrokerFrame> {
    public BrokerFrameEncoder() {
        super(new MimeType[]{MimeTypes.BROKER_FRAME_MIME_TYPE});
    }

    public Flux<DataBuffer> encode(Publisher<? extends BrokerFrame> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        return Flux.from(inputStream).map(value -> this.encodeValue((BrokerFrame)value, bufferFactory, elementType, mimeType, hints));
    }

    public DataBuffer encodeValue(BrokerFrame brokerFrame, DataBufferFactory bufferFactory, ResolvableType valueType, MimeType mimeType, Map<String, Object> hints) {
        ByteBuf encoded;
        NettyDataBufferFactory factory = (NettyDataBufferFactory)bufferFactory;
        ByteBufAllocator allocator = factory.getByteBufAllocator();
        switch (brokerFrame.getFrameType()) {
            case ADDRESS: {
                Address address = (Address)brokerFrame;
                encoded = AddressFlyweight.encode((ByteBufAllocator)allocator, (Id)address.getOriginRouteId(), (Tags)address.getMetadata(), (Tags)address.getTags(), (int)brokerFrame.getFlags());
                break;
            }
            case BROKER_INFO: {
                BrokerInfo brokerInfo = (BrokerInfo)brokerFrame;
                encoded = BrokerInfoFlyweight.encode((ByteBufAllocator)allocator, (Id)brokerInfo.getBrokerId(), (long)brokerInfo.getTimestamp(), (Tags)brokerInfo.getTags(), (int)brokerFrame.getFlags());
                break;
            }
            case ROUTE_JOIN: {
                RouteJoin routeJoin = (RouteJoin)brokerFrame;
                encoded = RouteJoinFlyweight.encode((ByteBufAllocator)allocator, (Id)routeJoin.getBrokerId(), (Id)routeJoin.getRouteId(), (long)routeJoin.getTimestamp(), (String)routeJoin.getServiceName(), (Tags)routeJoin.getTags(), (int)brokerFrame.getFlags());
                break;
            }
            case ROUTE_REMOVE: {
                RouteRemove routeRemove = (RouteRemove)brokerFrame;
                encoded = RouteRemoveFlyweight.encode((ByteBufAllocator)allocator, (Id)routeRemove.getBrokerId(), (Id)routeRemove.getRouteId(), (long)routeRemove.getTimestamp(), (int)brokerFrame.getFlags());
                break;
            }
            case ROUTE_SETUP: {
                RouteSetup routeSetup = (RouteSetup)brokerFrame;
                encoded = RouteSetupFlyweight.encode((ByteBufAllocator)allocator, (Id)routeSetup.getRouteId(), (String)routeSetup.getServiceName(), (Tags)routeSetup.getTags(), (int)brokerFrame.getFlags());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown FrameType " + brokerFrame.getFrameType());
            }
        }
        return factory.wrap(encoded);
    }
}

