/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.common;

import io.rsocket.broker.common.ImmutableKey;
import io.rsocket.broker.common.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum WellKnownKey {
    UNPARSEABLE_KEY("UNPARSEABLE_KEY_DO_NOT_USE", -2),
    UNKNOWN_RESERVED_KEY("UNKNOWN_YET_RESERVED_DO_NOT_USE", -1),
    NO_TAG("NO_TAG_DO_NOT_USE", 0),
    SERVICE_NAME("io.rsocket.broker.ServiceName", 1),
    ROUTE_ID("io.rsocket.broker.RouteId", 2),
    INSTANCE_NAME("io.rsocket.broker.InstanceName", 3),
    CLUSTER_NAME("io.rsocket.broker.ClusterName", 4),
    PROVIDER("io.rsocket.broker.Provider", 5),
    REGION("io.rsocket.broker.Region", 6),
    ZONE("io.rsocket.broker.Zone", 7),
    DEVICE("io.rsocket.broker.Device", 8),
    OS("io.rsocket.broker.OS", 9),
    USER_NAME("io.rsocket.broker.UserName", 10),
    USER_ID("io.rsocket.broker.UserId", 11),
    MAJOR_VERSION("io.rsocket.broker.MajorVersion", 12),
    MINOR_VERSION("io.rsocket.broker.MinorVersion", 13),
    PATCH_VERSION("io.rsocket.broker.PatchVersion", 14),
    VERSION("io.rsocket.broker.Version", 15),
    ENVIRONMENT("io.rsocket.broker.Environment", 16),
    TESTC_ELL("io.rsocket.broker.TestCell", 17),
    DNS("io.rsocket.broker.DNS", 18),
    IPV4("io.rsocket.broker.IPv4", 19),
    IPV6("io.rsocket.broker.IPv6", 20),
    COUNTRY("io.rsocket.broker.Country", 21),
    TIME_ZONE("io.rsocket.broker.TimeZone", 26),
    SHARD_KEY("io.rsocket.broker.ShardKey", 27),
    SHARD_METHOD("io.rsocket.broker.ShardMethod", 28),
    STICKY_ROUTE_KEY("io.rsocket.broker.StickyRouteKey", 29),
    LB_METHOD("io.rsocket.broker.LBMethod", 30),
    BROKER_EXTENSION("Broker Implementation Extension Key", 31),
    WELL_KNOWN_EXTENSION("Well Known Extension Key", 32),
    BROKER_PROXY_URI("Broker Proxy URI Key", 33),
    BROKER_CLUSTER_URI("Broker Cluster URI Key", 34);

    static final WellKnownKey[] TYPES_BY_ID;
    static final Map<String, WellKnownKey> TYPES_BY_STRING;
    private final byte identifier;
    private final String str;
    private final Key key;

    private WellKnownKey(String str, byte identifier) {
        this.str = str;
        this.identifier = identifier;
        this.key = new ImmutableKey(this);
    }

    public static WellKnownKey fromIdentifier(int id) {
        if (id < 0 || id > 127) {
            return UNPARSEABLE_KEY;
        }
        return TYPES_BY_ID[id];
    }

    public static WellKnownKey fromMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("type must be non-null");
        }
        if (mimeType.equals(WellKnownKey.UNKNOWN_RESERVED_KEY.str)) {
            return UNPARSEABLE_KEY;
        }
        return TYPES_BY_STRING.getOrDefault(mimeType, UNPARSEABLE_KEY);
    }

    public byte getIdentifier() {
        return this.identifier;
    }

    public String getString() {
        return this.str;
    }

    public Key getKey() {
        return this.key;
    }

    public String toString() {
        return this.str;
    }

    static {
        TYPES_BY_ID = new WellKnownKey[128];
        Arrays.fill((Object[])TYPES_BY_ID, (Object)UNKNOWN_RESERVED_KEY);
        TYPES_BY_STRING = new HashMap<String, WellKnownKey>(128);
        for (WellKnownKey value : WellKnownKey.values()) {
            if (value.getIdentifier() < 0) continue;
            WellKnownKey.TYPES_BY_ID[value.getIdentifier()] = value;
            TYPES_BY_STRING.put(value.getString(), value);
        }
    }
}

