/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.frames.FlyweightUtils;
import io.rsocket.broker.frames.FrameHeaderFlyweight;
import io.rsocket.broker.frames.FrameType;
import io.rsocket.broker.frames.TagsFlyweight;
import java.util.Objects;

public class AddressFlyweight {
    public static final int FLAGS_I = 512;
    public static final int FLAGS_E = 256;
    public static final int FLAGS_U = 128;
    public static final int FLAGS_M = 64;
    public static final int FLAGS_S = 32;
    static final int ROUTING_TYPE_MASK = 799;

    public static ByteBuf encode(ByteBufAllocator allocator, Id originRouteId, Tags metadata, Tags tags, int flags) {
        Objects.requireNonNull(originRouteId, "originRouteId may not be null");
        Objects.requireNonNull(tags, "tags may not be null");
        ByteBuf byteBuf = FrameHeaderFlyweight.encode(allocator, FrameType.ADDRESS, flags);
        FlyweightUtils.encodeId(byteBuf, originRouteId);
        TagsFlyweight.encode(byteBuf, tags);
        return byteBuf;
    }

    public static Id originRouteId(ByteBuf byteBuf) {
        return FlyweightUtils.decodeId(byteBuf, 6);
    }

    public static Tags metadata(ByteBuf byteBuf) {
        return Tags.empty();
    }

    public static Tags tags(ByteBuf byteBuf) {
        int offset = 22;
        return TagsFlyweight.decode(offset, byteBuf);
    }
}

