/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.rsocket.broker.common.Id;
import java.nio.charset.StandardCharsets;

public class FlyweightUtils {
    public static final int ID_BYTES = 16;
    private static final int UNSIGNED_BYTE_SIZE = 8;
    private static final int UNSIGNED_BYTE_MAX_VALUE = 255;

    static void encodeByteString(ByteBuf byteBuf, String s) {
        int length = FlyweightUtils.requireUnsignedByte(ByteBufUtil.utf8Bytes((CharSequence)s));
        byteBuf.writeByte(length);
        ByteBufUtil.reserveAndWriteUtf8((ByteBuf)byteBuf, (CharSequence)s, (int)length);
    }

    static String decodeByteString(ByteBuf byteBuf, int offset) {
        int length = byteBuf.getByte(offset);
        return byteBuf.toString(++offset, length &= 0xFF, StandardCharsets.UTF_8);
    }

    static int decodeByteStringLength(ByteBuf byteBuf, int offset) {
        int length = byteBuf.getByte(offset);
        return 1 + (length &= 0xFF);
    }

    static int requireUnsignedByte(int i) {
        if (i > 255) {
            throw new IllegalArgumentException(String.format("%d is larger than %d bits", i, 8));
        }
        return i;
    }

    static void encodeId(ByteBuf byteBuf, Id id) {
        byteBuf.writeLong(id.getFirst());
        byteBuf.writeLong(id.getSecond());
    }

    static Id decodeId(ByteBuf byteBuf, int offset) {
        long first = byteBuf.getLong(offset);
        long second = byteBuf.getLong(offset + 8);
        return new Id(first, second);
    }
}

