/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

public enum FrameType {
    RESERVED(0),
    ROUTE_SETUP(1),
    ROUTE_JOIN(2),
    ROUTE_REMOVE(3),
    BROKER_INFO(4),
    ADDRESS(5);

    private static FrameType[] frameTypesById;
    private final int id;

    private FrameType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static FrameType from(int id) {
        return frameTypesById[id];
    }

    static {
        frameTypesById = new FrameType[FrameType.values().length];
        FrameType[] frameTypeArray = FrameType.values();
        int n = frameTypeArray.length;
        for (int i = 0; i < n; ++i) {
            FrameType frameType;
            FrameType.frameTypesById[frameType.id] = frameType = frameTypeArray[i];
        }
    }
}

