/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.frames.BrokerFrame;
import io.rsocket.broker.frames.FrameType;
import io.rsocket.broker.frames.RouteRemoveFlyweight;
import java.util.Objects;
import java.util.StringJoiner;

public final class RouteRemove
extends BrokerFrame {
    private final Id brokerId;
    private final Id routeId;
    private final long timestamp;

    public RouteRemove(Id brokerId, Id routeId, long timestamp) {
        super(FrameType.ROUTE_REMOVE, 0);
        this.brokerId = brokerId;
        this.routeId = routeId;
        this.timestamp = timestamp;
    }

    public Id getBrokerId() {
        return this.brokerId;
    }

    public Id getRouteId() {
        return this.routeId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteRemove routeJoin = (RouteRemove)o;
        return this.timestamp == routeJoin.timestamp && Objects.equals(this.brokerId, routeJoin.brokerId) && Objects.equals(this.routeId, routeJoin.routeId);
    }

    public int hashCode() {
        return Objects.hash(this.brokerId, this.routeId, this.timestamp);
    }

    public String toString() {
        return new StringJoiner(", ", RouteRemove.class.getSimpleName() + "[", "]").add("brokerId=" + this.brokerId).add("routeId=" + this.routeId).add("timestamp=" + this.timestamp).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RouteRemove from(ByteBuf byteBuf) {
        return RouteRemove.builder().brokerId(RouteRemoveFlyweight.brokerId(byteBuf)).routeId(RouteRemoveFlyweight.routeId(byteBuf)).timestamp(RouteRemoveFlyweight.timestamp(byteBuf)).build();
    }

    public static final class Builder {
        private Id brokerId;
        private Id routeId;
        private long timestamp = System.currentTimeMillis();

        public Builder brokerId(Id brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public Builder routeId(Id routeId) {
            this.routeId = routeId;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public RouteRemove build() {
            Objects.requireNonNull(this.brokerId, "brokerId may not be null");
            Objects.requireNonNull(this.routeId, "brokerId may not be null");
            if (this.timestamp <= 0L) {
                throw new IllegalArgumentException("timestamp must be > 0");
            }
            return new RouteRemove(this.brokerId, this.routeId, this.timestamp);
        }
    }
}

