/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker.frames;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.frames.FlyweightUtils;
import io.rsocket.broker.frames.FrameHeaderFlyweight;
import io.rsocket.broker.frames.FrameType;
import io.rsocket.broker.frames.TagsFlyweight;
import java.util.Objects;

public class RouteSetupFlyweight {
    public static ByteBuf encode(ByteBufAllocator allocator, Id routeId, String serviceName, Tags tags, int flags) {
        Objects.requireNonNull(routeId, "routeId may not be null");
        Objects.requireNonNull(serviceName, "serviceName may not be null");
        Objects.requireNonNull(tags, "tags may not be null");
        ByteBuf byteBuf = FrameHeaderFlyweight.encode(allocator, FrameType.ROUTE_SETUP, flags);
        FlyweightUtils.encodeId(byteBuf, routeId);
        FlyweightUtils.encodeByteString(byteBuf, serviceName);
        TagsFlyweight.encode(byteBuf, tags);
        return byteBuf;
    }

    public static Id routeId(ByteBuf byteBuf) {
        return FlyweightUtils.decodeId(byteBuf, 6);
    }

    public static String serviceName(ByteBuf byteBuf) {
        int offset = 22;
        return FlyweightUtils.decodeByteString(byteBuf, offset);
    }

    public static Tags tags(ByteBuf byteBuf) {
        int offset = 22;
        offset += FlyweightUtils.decodeByteStringLength(byteBuf, offset);
        return TagsFlyweight.decode(offset, byteBuf);
    }
}

