/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.broker;

import io.rsocket.broker.common.Id;
import io.rsocket.broker.common.Tags;
import io.rsocket.broker.frames.RouteJoin;
import io.rsocket.broker.util.IndexedMap;
import io.rsocket.broker.util.RoaringBitmapIndexedMap;
import java.util.List;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class RoutingTable
implements Disposable {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTable.class);
    private final IndexedMap<Id, RouteJoin, Tags> routes = new RoaringBitmapIndexedMap<RouteJoin>();
    private final Sinks.Many<RouteJoin> joinEvents = Sinks.many().multicast().directBestEffort();
    private final Sinks.Many<RouteJoin> leaveEvents = Sinks.many().multicast().directBestEffort();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouteJoin find(Id routeId) {
        IndexedMap<Id, RouteJoin, Tags> indexedMap = this.routes;
        synchronized (indexedMap) {
            return this.routes.get(routeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RouteJoin> find(Tags tags) {
        IndexedMap<Id, RouteJoin, Tags> indexedMap = this.routes;
        synchronized (indexedMap) {
            return this.routes.query(tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RouteJoin routeJoin) {
        logger.debug("adding RouteJoin {}", (Object)routeJoin);
        IndexedMap<Id, RouteJoin, Tags> indexedMap = this.routes;
        synchronized (indexedMap) {
            this.routes.put(routeJoin.getRouteId(), routeJoin, routeJoin.getTags());
        }
        this.joinEvents.tryEmitNext((Object)routeJoin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Id routeId) {
        logger.debug("removing routeId {}", (Object)routeId);
        IndexedMap<Id, RouteJoin, Tags> indexedMap = this.routes;
        synchronized (indexedMap) {
            RouteJoin routeJoin = this.routes.remove(routeId);
            if (routeJoin != null) {
                this.leaveEvents.tryEmitNext((Object)routeJoin);
            }
        }
    }

    public Flux<RouteJoin> joinEvents(Predicate<RouteJoin> predicate) {
        return Flux.mergeSequential((Publisher[])new Publisher[]{Flux.fromIterable(this.routes.values()), this.joinEvents.asFlux()}).filter(predicate);
    }

    public Flux<RouteJoin> joinEvents(Tags tags) {
        return this.joinEvents(RoutingTable.containsTags(tags));
    }

    public Flux<RouteJoin> leaveEvents(Tags tags) {
        return this.leaveEvents.asFlux().filter(RoutingTable.containsTags(tags));
    }

    public void dispose() {
        this.routes.clear();
    }

    static Predicate<RouteJoin> containsTags(Tags tags) {
        return event -> {
            boolean contains = event.getTags().entries().containsAll(tags.entries());
            return contains;
        };
    }
}

