/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.routing.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketClient;
import io.rsocket.core.RSocketConnector;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.metadata.CompositeMetadataCodec;
import io.rsocket.metadata.WellKnownMimeType;
import io.rsocket.routing.client.RoutingRSocketClient;
import io.rsocket.routing.common.Id;
import io.rsocket.routing.common.Tags;
import io.rsocket.routing.frames.RouteSetupFlyweight;
import io.rsocket.transport.ClientTransport;
import io.rsocket.util.DefaultPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class RoutingRSocketConnector {
    private RSocketConnector delegate;
    private Id routeId;
    private String serviceName;
    private List<Tuple2<ByteBuf, String>> setupMetadatas = new ArrayList<Tuple2<ByteBuf, String>>();
    private Tags tags;
    private ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
    private ByteBuf setupData = Unpooled.EMPTY_BUFFER;

    private RoutingRSocketConnector() {
        this(RSocketConnector.create().payloadDecoder(PayloadDecoder.ZERO_COPY).metadataMimeType(WellKnownMimeType.MESSAGE_RSOCKET_COMPOSITE_METADATA.getString()));
    }

    private RoutingRSocketConnector(RSocketConnector rSocketConnector) {
        this.delegate = rSocketConnector;
    }

    Id getRouteId() {
        return this.routeId;
    }

    ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    public static RoutingRSocketConnector create() {
        return new RoutingRSocketConnector();
    }

    public static RoutingRSocketConnector create(RSocketConnector connector) {
        return new RoutingRSocketConnector(connector);
    }

    public RoutingRSocketConnector configure(Consumer<RSocketConnector> consumer) {
        consumer.accept(this.delegate);
        return this;
    }

    public RoutingRSocketConnector byteBufAllocator(ByteBufAllocator allocator) {
        this.allocator = allocator;
        return this;
    }

    public RoutingRSocketConnector routeId(Id routeId) {
        this.routeId = routeId;
        return this;
    }

    public RoutingRSocketConnector serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public RoutingRSocketConnector setupTags(Tags tags) {
        this.tags = tags;
        return this;
    }

    public RoutingRSocketConnector setupMetadata(ByteBuf byteBuf, String mimeType) {
        this.setupMetadatas.add((Tuple2<ByteBuf, String>)Tuples.of((Object)byteBuf, (Object)mimeType));
        return this;
    }

    public RoutingRSocketConnector setupData(ByteBuf byteBuf) {
        this.setupData = byteBuf;
        return this;
    }

    public Mono<RSocket> connect(ClientTransport transport) {
        this.createSetupPayload();
        return this.delegate.connect(transport);
    }

    public Mono<RSocket> connect(Supplier<ClientTransport> transportSupplier) {
        this.createSetupPayload();
        return this.delegate.connect(transportSupplier);
    }

    public RoutingRSocketClient toRSocketClient(ClientTransport transport) {
        this.createSetupPayload();
        return new RoutingRSocketClient(this, RSocketClient.from((Mono)this.delegate.connect(transport)));
    }

    private void createSetupPayload() {
        Id setupRouteId;
        Tags setupTags = this.tags;
        if (setupTags == null) {
            setupTags = Tags.empty();
        }
        if ((setupRouteId = this.routeId) == null) {
            setupRouteId = Id.random();
        }
        if (this.serviceName == null || this.serviceName.isEmpty()) {
            throw new IllegalArgumentException("serviceName must not be null or empty");
        }
        ByteBuf routeSetup = RouteSetupFlyweight.encode((ByteBufAllocator)this.allocator, (Id)setupRouteId, (String)this.serviceName, (Tags)setupTags, (int)0);
        CompositeByteBuf setupMetadata = this.allocator.compositeBuffer();
        CompositeMetadataCodec.encodeAndAddMetadata((CompositeByteBuf)setupMetadata, (ByteBufAllocator)this.allocator, (String)"message/x.rsocket.routing.frame.v0".toString(), (ByteBuf)routeSetup);
        this.setupMetadatas.forEach(entry -> CompositeMetadataCodec.encodeAndAddMetadata((CompositeByteBuf)setupMetadata, (ByteBufAllocator)this.allocator, (String)((String)entry.getT2()), (ByteBuf)((ByteBuf)entry.getT1())));
        Payload setupPayload = DefaultPayload.create((ByteBuf)this.setupData, (ByteBuf)setupMetadata);
        this.delegate.setupPayload(setupPayload);
    }
}

