/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.routing.common;

import java.util.Objects;
import java.util.UUID;

public class Id {
    private final long first;
    private final long second;

    public Id(long first, long second) {
        this.first = first;
        this.second = second;
    }

    public long getFirst() {
        return this.first;
    }

    public long getSecond() {
        return this.second;
    }

    public String toString() {
        return "Id{" + new UUID(this.first, this.second) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id id = (Id)o;
        return this.first == id.first && this.second == id.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public static Id from(long[] parts) {
        if (parts == null || parts.length != 2) {
            throw new IllegalArgumentException("parts must have a length of 2");
        }
        return new Id(parts[0], parts[1]);
    }

    public static Id valueOf(String uuid) {
        return Id.from(uuid);
    }

    public static Id from(String uuid) {
        return Id.from(UUID.fromString(uuid));
    }

    public static Id from(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid may not be null");
        return new Id(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static Id random() {
        return Id.from(UUID.randomUUID());
    }
}

