/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.routing.common;

import io.rsocket.routing.common.Key;
import io.rsocket.routing.common.WellKnownKey;
import java.util.Objects;
import java.util.StringJoiner;

public class ImmutableKey
implements Key {
    private final WellKnownKey wellKnownKey;
    private final String key;

    public ImmutableKey(WellKnownKey wellKnownKey) {
        this(wellKnownKey, null);
    }

    public ImmutableKey(String key) {
        this(null, key);
    }

    private ImmutableKey(WellKnownKey wellKnownKey, String key) {
        this.wellKnownKey = wellKnownKey;
        this.key = key;
    }

    @Override
    public WellKnownKey getWellKnownKey() {
        return this.wellKnownKey;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key1 = (Key)o;
        return this.wellKnownKey == key1.getWellKnownKey() && Objects.equals(this.key, key1.getKey());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.wellKnownKey, this.key});
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        if (this.wellKnownKey != null) {
            joiner.add(this.wellKnownKey.toString());
            joiner.add(String.format("0x%02x", this.wellKnownKey.getIdentifier()));
        }
        if (this.key != null) {
            joiner.add("'" + this.key + "'");
        }
        return joiner.toString();
    }
}

