/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.routing.common;

import io.rsocket.routing.common.Key;
import io.rsocket.routing.common.WellKnownKey;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Tags {
    private static final Tags EMPTY = Tags.builder().buildTags();
    private final Map<Key, String> tags;

    public Tags(Map<Key, String> tags) {
        Objects.requireNonNull(tags, "tags may not be null");
        this.tags = tags;
    }

    public Map<Key, String> asMap() {
        return this.tags;
    }

    public String get(WellKnownKey key) {
        return this.tags.get(Key.of(key));
    }

    public String get(String key) {
        return this.tags.get(Key.of(key));
    }

    public boolean containsKey(WellKnownKey key) {
        return this.tags.containsKey(Key.of(key));
    }

    public boolean containsKey(String key) {
        return this.tags.containsKey(Key.of(key));
    }

    public Set<Map.Entry<Key, String>> entries() {
        return this.tags.entrySet();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public String toString() {
        return Tags.class.getSimpleName() + this.tags.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tags tags1 = (Tags)o;
        return this.tags.equals(tags1.tags);
    }

    public int hashCode() {
        return Objects.hash(this.tags);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static Tags empty() {
        return EMPTY;
    }

    public static class Builder<SELF extends Builder<SELF>> {
        private final Map<Key, String> tags = new LinkedHashMap<Key, String>();

        protected Builder() {
        }

        public SELF with(String key, String value) {
            Objects.requireNonNull(key, "key may not be null");
            if (key.length() > 128) {
                throw new IllegalArgumentException("key length can not be greater than 128, was " + key.length());
            }
            return this.with(Key.of(key), value);
        }

        public SELF with(WellKnownKey key, String value) {
            Objects.requireNonNull(key, "key may not be null");
            return this.with(Key.of(key), value);
        }

        public SELF with(Key key, String value) {
            Objects.requireNonNull(key, "key may not be null");
            if (value != null && value.length() > 128) {
                throw new IllegalArgumentException("value length can not be greater than 128, was " + value.length());
            }
            this.tags.put(key, value);
            return (SELF)this;
        }

        public SELF with(Tags tags) {
            this.tags.putAll(tags.asMap());
            return (SELF)this;
        }

        protected Map<Key, String> getTags() {
            return this.tags;
        }

        public Tags buildTags() {
            return new Tags(Collections.unmodifiableMap(this.tags));
        }
    }
}

