/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.routing.common;

import io.rsocket.routing.common.ImmutableKey;
import io.rsocket.routing.common.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum WellKnownKey {
    UNPARSEABLE_KEY("UNPARSEABLE_KEY_DO_NOT_USE", -2),
    UNKNOWN_RESERVED_KEY("UNKNOWN_YET_RESERVED_DO_NOT_USE", -1),
    NO_TAG("NO_TAG_DO_NOT_USE", 0),
    SERVICE_NAME("io.rsocket.routing.ServiceName", 1),
    ROUTE_ID("io.rsocket.routing.RouteId", 2),
    INSTANCE_NAME("io.rsocket.routing.InstanceName", 3),
    CLUSTER_NAME("io.rsocket.routing.ClusterName", 4),
    PROVIDER("io.rsocket.routing.Provider", 5),
    REGION("io.rsocket.routing.Region", 6),
    ZONE("io.rsocket.routing.Zone", 7),
    DEVICE("io.rsocket.routing.Device", 8),
    OS("io.rsocket.routing.OS", 9),
    USER_NAME("io.rsocket.routing.UserName", 10),
    USER_ID("io.rsocket.routing.UserId", 11),
    MAJOR_VERSION("io.rsocket.routing.MajorVersion", 12),
    MINOR_VERSION("io.rsocket.routing.MinorVersion", 13),
    PATCH_VERSION("io.rsocket.routing.PatchVersion", 14),
    VERSION("io.rsocket.routing.Version", 15),
    ENVIRONMENT("io.rsocket.routing.Environment", 16),
    TESTC_ELL("io.rsocket.routing.TestCell", 17),
    DNS("io.rsocket.routing.DNS", 18),
    IPV4("io.rsocket.routing.IPv4", 19),
    IPV6("io.rsocket.routing.IPv6", 20),
    COUNTRY("io.rsocket.routing.Country", 21),
    TIME_ZONE("io.rsocket.routing.TimeZone", 26),
    SHARD_KEY("io.rsocket.routing.ShardKey", 27),
    SHARD_METHOD("io.rsocket.routing.ShardMethod", 28),
    STICKY_ROUTE_KEY("io.rsocket.routing.StickyRouteKey", 29),
    LB_METHOD("io.rsocket.routing.LBMethod", 30),
    BROKER_EXTENSION("Broker Implementation Extension Key", 30),
    WELL_KNOWN_EXTENSION("Well Known Extension Key", 30);

    static final WellKnownKey[] TYPES_BY_ID;
    static final Map<String, WellKnownKey> TYPES_BY_STRING;
    private final byte identifier;
    private final String str;
    private final Key key;

    private WellKnownKey(String str, byte identifier) {
        this.str = str;
        this.identifier = identifier;
        this.key = new ImmutableKey(this);
    }

    public static WellKnownKey fromIdentifier(int id) {
        if (id < 0 || id > 127) {
            return UNPARSEABLE_KEY;
        }
        return TYPES_BY_ID[id];
    }

    public static WellKnownKey fromMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("type must be non-null");
        }
        if (mimeType.equals(WellKnownKey.UNKNOWN_RESERVED_KEY.str)) {
            return UNPARSEABLE_KEY;
        }
        return TYPES_BY_STRING.getOrDefault(mimeType, UNPARSEABLE_KEY);
    }

    public byte getIdentifier() {
        return this.identifier;
    }

    public String getString() {
        return this.str;
    }

    public Key getKey() {
        return this.key;
    }

    public String toString() {
        return this.str;
    }

    static {
        TYPES_BY_ID = new WellKnownKey[128];
        Arrays.fill((Object[])TYPES_BY_ID, (Object)UNKNOWN_RESERVED_KEY);
        TYPES_BY_STRING = new HashMap<String, WellKnownKey>(128);
        for (WellKnownKey value : WellKnownKey.values()) {
            if (value.getIdentifier() < 0) continue;
            WellKnownKey.TYPES_BY_ID[value.getIdentifier()] = value;
            TYPES_BY_STRING.put(value.getString(), value);
        }
    }
}

