/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscGrowableAtomicArrayQueue;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

public final class UnboundedProcessor<T>
extends FluxProcessor<T, T>
implements Fuseable.QueueSubscription<T>,
Fuseable {
    static final AtomicIntegerFieldUpdater<UnboundedProcessor> ONCE = AtomicIntegerFieldUpdater.newUpdater(UnboundedProcessor.class, "once");
    static final AtomicIntegerFieldUpdater<UnboundedProcessor> WIP = AtomicIntegerFieldUpdater.newUpdater(UnboundedProcessor.class, "wip");
    static final AtomicLongFieldUpdater<UnboundedProcessor> REQUESTED = AtomicLongFieldUpdater.newUpdater(UnboundedProcessor.class, "requested");
    final Queue<T> queue = new MpscGrowableAtomicArrayQueue(Queues.SMALL_BUFFER_SIZE, 0x1000000);
    volatile boolean done;
    Throwable error;
    volatile CoreSubscriber<? super T> actual;
    volatile boolean cancelled;
    volatile int once;
    volatile int wip;
    volatile long requested;
    volatile long processed;

    public int getBufferSize() {
        return Queues.capacity(this.queue);
    }

    void drainRegular(Subscriber<? super T> a) {
        int missed = 1;
        Queue<T> q = this.queue;
        do {
            long e;
            long r = this.requested;
            for (e = 0L; r != e; ++e) {
                boolean empty;
                boolean d = this.done;
                T t = q.poll();
                boolean bl = empty = t == null;
                if (this.checkTerminated(d, empty, a, q)) {
                    return;
                }
                if (empty) break;
                a.onNext(t);
            }
            if (r == e && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                return;
            }
            if (e == 0L || r == Long.MAX_VALUE) continue;
            REQUESTED.addAndGet(this, -e);
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    public void drain() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int missed = 1;
        do {
            CoreSubscriber<? super T> a;
            if ((a = this.actual) == null) continue;
            this.drainRegular((Subscriber<? super T>)a);
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a, Queue<T> q) {
        if (this.cancelled) {
            q.clear();
            this.actual = null;
            return true;
        }
        if (d && empty) {
            Throwable e = this.error;
            this.actual = null;
            if (e != null) {
                a.onError(e);
            } else {
                a.onComplete();
            }
            return true;
        }
        return false;
    }

    public void onSubscribe(Subscription s) {
        if (this.done || this.cancelled) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    public Context currentContext() {
        CoreSubscriber<? super T> actual = this.actual;
        return actual != null ? actual.currentContext() : Context.empty();
    }

    public void onNext(T t) {
        if (this.done || this.cancelled) {
            Operators.onNextDropped(t, (Context)this.currentContext());
            return;
        }
        if (!this.queue.offer(t)) {
            Throwable ex = Operators.onOperatorError(null, (Throwable)Exceptions.failWithOverflow(), t, (Context)this.currentContext());
            this.onError(Operators.onOperatorError(null, (Throwable)ex, t, (Context)this.currentContext()));
            return;
        }
        this.drain();
    }

    public void onError(Throwable t) {
        if (this.done || this.cancelled) {
            Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
            return;
        }
        this.error = t;
        this.done = true;
        this.drain();
    }

    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.drain();
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
            this.actual = actual;
            actual.onSubscribe((Subscription)this);
            if (this.cancelled) {
                this.actual = null;
            } else {
                this.drain();
            }
        } else {
            Operators.error(actual, (Throwable)new IllegalStateException("UnboundedProcessor allows only a single Subscriber"));
        }
    }

    public void request(long n) {
        if (Operators.validate((long)n)) {
            Operators.addCap(REQUESTED, (Object)((Object)this), (long)n);
            this.drain();
        }
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        if (WIP.getAndIncrement(this) == 0) {
            this.queue.clear();
        }
    }

    @Nullable
    public T poll() {
        return this.queue.poll();
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void clear() {
        this.queue.clear();
    }

    public int requestFusion(int requestedMode) {
        return 0;
    }

    public boolean isDisposed() {
        return this.cancelled || this.done;
    }

    public boolean isTerminated() {
        return this.done;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public long downstreamCount() {
        return this.hasDownstreams() ? 1L : 0L;
    }

    public boolean hasDownstreams() {
        return this.actual != null;
    }
}

