/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.SetupFrameFlyweight;
import java.util.UUID;

public class ResumeFrameFlyweight {
    static final int CURRENT_VERSION = SetupFrameFlyweight.CURRENT_VERSION;

    public static ByteBuf encode(ByteBufAllocator allocator, ByteBuf token, long lastReceivedServerPos, long firstAvailableClientPos) {
        ByteBuf byteBuf = FrameHeaderFlyweight.encodeStreamZero(allocator, FrameType.RESUME, 0);
        byteBuf.writeInt(CURRENT_VERSION);
        token.markReaderIndex();
        byteBuf.writeShort(token.readableBytes());
        byteBuf.writeBytes(token);
        token.resetReaderIndex();
        byteBuf.writeLong(lastReceivedServerPos);
        byteBuf.writeLong(firstAvailableClientPos);
        return byteBuf;
    }

    public static int version(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.RESUME, byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderFlyweight.size());
        int version = byteBuf.readInt();
        byteBuf.resetReaderIndex();
        return version;
    }

    public static ByteBuf token(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.RESUME, byteBuf);
        byteBuf.markReaderIndex();
        int tokenPos = FrameHeaderFlyweight.size() + 4;
        byteBuf.skipBytes(tokenPos);
        int tokenLength = byteBuf.readShort() & 0xFFFF;
        ByteBuf token = byteBuf.readSlice(tokenLength);
        byteBuf.resetReaderIndex();
        return token;
    }

    public static long lastReceivedServerPos(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.RESUME, byteBuf);
        byteBuf.markReaderIndex();
        int tokenPos = FrameHeaderFlyweight.size() + 4;
        byteBuf.skipBytes(tokenPos);
        int tokenLength = byteBuf.readShort() & 0xFFFF;
        byteBuf.skipBytes(tokenLength);
        long lastReceivedServerPos = byteBuf.readLong();
        byteBuf.resetReaderIndex();
        return lastReceivedServerPos;
    }

    public static long firstAvailableClientPos(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.RESUME, byteBuf);
        byteBuf.markReaderIndex();
        int tokenPos = FrameHeaderFlyweight.size() + 4;
        byteBuf.skipBytes(tokenPos);
        int tokenLength = byteBuf.readShort() & 0xFFFF;
        byteBuf.skipBytes(tokenLength);
        byteBuf.skipBytes(8);
        long firstAvailableClientPos = byteBuf.readLong();
        byteBuf.resetReaderIndex();
        return firstAvailableClientPos;
    }

    public static ByteBuf generateResumeToken() {
        UUID uuid = UUID.randomUUID();
        ByteBuf bb = Unpooled.buffer((int)16);
        bb.writeLong(uuid.getMostSignificantBits());
        bb.writeLong(uuid.getLeastSignificantBits());
        return bb;
    }
}

