/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.metadata;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.CharsetUtil;
import io.rsocket.metadata.WellKnownMimeType;
import io.rsocket.util.NumberUtils;
import java.nio.charset.Charset;
import reactor.util.annotation.Nullable;

public class CompositeMetadataFlyweight {
    static final int STREAM_METADATA_KNOWN_MASK = 128;
    static final byte STREAM_METADATA_LENGTH_MASK = 127;

    private CompositeMetadataFlyweight() {
    }

    public static int computeNextEntryIndex(int currentEntryIndex, ByteBuf headerSlice, ByteBuf contentSlice) {
        return currentEntryIndex + headerSlice.readableBytes() + 3 + contentSlice.readableBytes();
    }

    public static ByteBuf[] decodeMimeAndContentBuffersSlices(ByteBuf compositeMetadata, int entryIndex, boolean retainSlices) {
        compositeMetadata.markReaderIndex();
        compositeMetadata.readerIndex(entryIndex);
        if (compositeMetadata.isReadable()) {
            ByteBuf mime;
            int ridx = compositeMetadata.readerIndex();
            byte mimeIdOrLength = compositeMetadata.readByte();
            if ((mimeIdOrLength & 0x80) == 128) {
                mime = retainSlices ? compositeMetadata.retainedSlice(ridx, 1) : compositeMetadata.slice(ridx, 1);
            } else {
                int mimeLength = Byte.toUnsignedInt(mimeIdOrLength) + 1;
                if (compositeMetadata.isReadable(mimeLength)) {
                    mime = retainSlices ? compositeMetadata.retainedSlice(ridx, mimeLength + 1) : compositeMetadata.slice(ridx, mimeLength + 1);
                    compositeMetadata.skipBytes(mimeLength);
                } else {
                    compositeMetadata.resetReaderIndex();
                    throw new IllegalStateException("metadata is malformed");
                }
            }
            if (compositeMetadata.isReadable(3)) {
                int metadataLength = compositeMetadata.readUnsignedMedium();
                if (compositeMetadata.isReadable(metadataLength)) {
                    ByteBuf metadata = retainSlices ? compositeMetadata.readRetainedSlice(metadataLength) : compositeMetadata.readSlice(metadataLength);
                    compositeMetadata.resetReaderIndex();
                    return new ByteBuf[]{mime, metadata};
                }
                compositeMetadata.resetReaderIndex();
                throw new IllegalStateException("metadata is malformed");
            }
            compositeMetadata.resetReaderIndex();
            throw new IllegalStateException("metadata is malformed");
        }
        compositeMetadata.resetReaderIndex();
        throw new IllegalArgumentException(String.format("entry index %d is larger than buffer size", entryIndex));
    }

    public static byte decodeMimeIdFromMimeBuffer(ByteBuf mimeBuffer) {
        if (mimeBuffer.readableBytes() != 1) {
            return WellKnownMimeType.UNPARSEABLE_MIME_TYPE.getIdentifier();
        }
        return (byte)(mimeBuffer.readByte() & 0x7F);
    }

    @Nullable
    public static CharSequence decodeMimeTypeFromMimeBuffer(ByteBuf flyweightMimeBuffer) {
        if (flyweightMimeBuffer.readableBytes() < 2) {
            throw new IllegalStateException("unable to decode explicit MIME type");
        }
        flyweightMimeBuffer.skipBytes(1);
        int mimeStringLength = flyweightMimeBuffer.readableBytes();
        return flyweightMimeBuffer.readCharSequence(mimeStringLength, CharsetUtil.US_ASCII);
    }

    public static void encodeAndAddMetadata(CompositeByteBuf compositeMetaData, ByteBufAllocator allocator, String customMimeType, ByteBuf metadata) {
        compositeMetaData.addComponents(true, new ByteBuf[]{CompositeMetadataFlyweight.encodeMetadataHeader(allocator, customMimeType, metadata.readableBytes()), metadata});
    }

    public static void encodeAndAddMetadata(CompositeByteBuf compositeMetaData, ByteBufAllocator allocator, WellKnownMimeType knownMimeType, ByteBuf metadata) {
        compositeMetaData.addComponents(true, new ByteBuf[]{CompositeMetadataFlyweight.encodeMetadataHeader(allocator, knownMimeType.getIdentifier(), metadata.readableBytes()), metadata});
    }

    public static void encodeAndAddMetadataWithCompression(CompositeByteBuf compositeMetaData, ByteBufAllocator allocator, String mimeType, ByteBuf metadata) {
        WellKnownMimeType wkn = WellKnownMimeType.fromString(mimeType);
        if (wkn == WellKnownMimeType.UNPARSEABLE_MIME_TYPE) {
            compositeMetaData.addComponents(true, new ByteBuf[]{CompositeMetadataFlyweight.encodeMetadataHeader(allocator, mimeType, metadata.readableBytes()), metadata});
        } else {
            compositeMetaData.addComponents(true, new ByteBuf[]{CompositeMetadataFlyweight.encodeMetadataHeader(allocator, wkn.getIdentifier(), metadata.readableBytes()), metadata});
        }
    }

    public static boolean hasEntry(ByteBuf compositeMetadata, int entryIndex) {
        return compositeMetadata.writerIndex() - entryIndex > 0;
    }

    public static boolean isWellKnownMimeType(ByteBuf header) {
        return header.readableBytes() == 1;
    }

    static void encodeAndAddMetadata(CompositeByteBuf compositeMetaData, ByteBufAllocator allocator, byte unknownCompressedMimeType, ByteBuf metadata) {
        compositeMetaData.addComponents(true, new ByteBuf[]{CompositeMetadataFlyweight.encodeMetadataHeader(allocator, unknownCompressedMimeType, metadata.readableBytes()), metadata});
    }

    static ByteBuf encodeMetadataHeader(ByteBufAllocator allocator, String customMime, int metadataLength) {
        ByteBuf metadataHeader = allocator.buffer(4 + customMime.length());
        int writerIndexInitial = metadataHeader.writerIndex();
        metadataHeader.writerIndex(writerIndexInitial + 1);
        int customMimeLength = ByteBufUtil.writeUtf8((ByteBuf)metadataHeader, (CharSequence)customMime);
        if (!ByteBufUtil.isText((ByteBuf)metadataHeader, (Charset)CharsetUtil.US_ASCII)) {
            metadataHeader.release();
            throw new IllegalArgumentException("custom mime type must be US_ASCII characters only");
        }
        if (customMimeLength < 1 || customMimeLength > 128) {
            metadataHeader.release();
            throw new IllegalArgumentException("custom mime type must have a strictly positive length that fits on 7 unsigned bits, ie 1-128");
        }
        metadataHeader.markWriterIndex();
        metadataHeader.writerIndex(writerIndexInitial);
        metadataHeader.writeByte(customMimeLength - 1);
        metadataHeader.resetWriterIndex();
        NumberUtils.encodeUnsignedMedium(metadataHeader, metadataLength);
        return metadataHeader;
    }

    static ByteBuf encodeMetadataHeader(ByteBufAllocator allocator, byte mimeType, int metadataLength) {
        ByteBuf buffer = allocator.buffer(4, 4).writeByte(mimeType | 0x80);
        NumberUtils.encodeUnsignedMedium(buffer, metadataLength);
        return buffer;
    }
}

