/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.AbstractRSocket;
import io.rsocket.Closeable;
import io.rsocket.ConnectionSetupPayload;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.RSocketRequester;
import io.rsocket.RSocketResponder;
import io.rsocket.SocketAcceptor;
import io.rsocket.StreamIdSupplier;
import io.rsocket.exceptions.InvalidSetupException;
import io.rsocket.exceptions.RejectedSetupException;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.ResumeFrameFlyweight;
import io.rsocket.frame.SetupFrameFlyweight;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.ClientServerInputMultiplexer;
import io.rsocket.internal.ClientSetup;
import io.rsocket.internal.ServerSetup;
import io.rsocket.keepalive.KeepAliveHandler;
import io.rsocket.lease.LeaseStats;
import io.rsocket.lease.Leases;
import io.rsocket.lease.RequesterLeaseHandler;
import io.rsocket.lease.ResponderLeaseHandler;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.PluginRegistry;
import io.rsocket.plugins.Plugins;
import io.rsocket.plugins.RSocketInterceptor;
import io.rsocket.plugins.SocketAcceptorInterceptor;
import io.rsocket.resume.ExponentialBackoffResumeStrategy;
import io.rsocket.resume.InMemoryResumableFramesStore;
import io.rsocket.resume.ResumableFramesStore;
import io.rsocket.resume.ResumeStrategy;
import io.rsocket.resume.SessionManager;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import io.rsocket.util.ConnectionUtils;
import io.rsocket.util.EmptyPayload;
import io.rsocket.util.MultiSubscriberRSocket;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class RSocketFactory {
    public static ClientRSocketFactory connect() {
        return new ClientRSocketFactory();
    }

    public static ServerRSocketFactory receive() {
        return new ServerRSocketFactory();
    }

    public static class ServerRSocketFactory {
        private static final String SERVER_TAG = "server";
        private SocketAcceptor acceptor;
        private PayloadDecoder payloadDecoder = PayloadDecoder.DEFAULT;
        private Consumer<Throwable> errorConsumer = Throwable::printStackTrace;
        private int mtu = 0;
        private PluginRegistry plugins = new PluginRegistry(Plugins.defaultPlugins());
        private boolean resumeSupported;
        private Duration resumeSessionDuration = Duration.ofSeconds(120L);
        private Duration resumeStreamTimeout = Duration.ofSeconds(10L);
        private Function<? super ByteBuf, ? extends ResumableFramesStore> resumeStoreFactory = token -> new InMemoryResumableFramesStore(SERVER_TAG, 100000);
        private boolean multiSubscriberRequester = true;
        private boolean leaseEnabled;
        private Supplier<Leases<?>> leasesSupplier = Leases::new;
        private ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
        private boolean resumeCleanupStoreOnKeepAlive;

        private ServerRSocketFactory() {
        }

        public ServerRSocketFactory byteBufAllocator(ByteBufAllocator allocator) {
            Objects.requireNonNull(allocator);
            this.allocator = allocator;
            return this;
        }

        public ServerRSocketFactory addConnectionPlugin(DuplexConnectionInterceptor interceptor) {
            this.plugins.addConnectionPlugin(interceptor);
            return this;
        }

        @Deprecated
        public ServerRSocketFactory addClientPlugin(RSocketInterceptor interceptor) {
            return this.addRequesterPlugin(interceptor);
        }

        public ServerRSocketFactory addRequesterPlugin(RSocketInterceptor interceptor) {
            this.plugins.addRequesterPlugin(interceptor);
            return this;
        }

        @Deprecated
        public ServerRSocketFactory addServerPlugin(RSocketInterceptor interceptor) {
            return this.addResponderPlugin(interceptor);
        }

        public ServerRSocketFactory addResponderPlugin(RSocketInterceptor interceptor) {
            this.plugins.addResponderPlugin(interceptor);
            return this;
        }

        public ServerRSocketFactory addSocketAcceptorPlugin(SocketAcceptorInterceptor interceptor) {
            this.plugins.addSocketAcceptorPlugin(interceptor);
            return this;
        }

        public ServerTransportAcceptor acceptor(SocketAcceptor acceptor) {
            this.acceptor = acceptor;
            return new ServerStart();
        }

        public ServerRSocketFactory frameDecoder(PayloadDecoder payloadDecoder) {
            this.payloadDecoder = payloadDecoder;
            return this;
        }

        public ServerRSocketFactory fragment(int mtu) {
            this.mtu = mtu;
            return this;
        }

        public ServerRSocketFactory errorConsumer(Consumer<Throwable> errorConsumer) {
            this.errorConsumer = errorConsumer;
            return this;
        }

        public ServerRSocketFactory lease(Supplier<Leases<?>> leasesSupplier) {
            this.leaseEnabled = true;
            this.leasesSupplier = Objects.requireNonNull(leasesSupplier);
            return this;
        }

        public ServerRSocketFactory lease() {
            this.leaseEnabled = true;
            return this;
        }

        public ServerRSocketFactory singleSubscriberRequester() {
            this.multiSubscriberRequester = false;
            return this;
        }

        public ServerRSocketFactory resume() {
            this.resumeSupported = true;
            return this;
        }

        public ServerRSocketFactory resumeStore(Function<? super ByteBuf, ? extends ResumableFramesStore> resumeStoreFactory) {
            this.resumeStoreFactory = resumeStoreFactory;
            return this;
        }

        public ServerRSocketFactory resumeSessionDuration(Duration sessionDuration) {
            this.resumeSessionDuration = Objects.requireNonNull(sessionDuration);
            return this;
        }

        public ServerRSocketFactory resumeStreamTimeout(Duration resumeStreamTimeout) {
            this.resumeStreamTimeout = Objects.requireNonNull(resumeStreamTimeout);
            return this;
        }

        public ServerRSocketFactory resumeCleanupOnKeepAlive() {
            this.resumeCleanupStoreOnKeepAlive = true;
            return this;
        }

        private class ServerStart<T extends Closeable>
        implements Start<T>,
        ServerTransportAcceptor {
            private Supplier<ServerTransport<T>> transportServer;

            private ServerStart() {
            }

            @Override
            public ServerTransport.ConnectionAcceptor toConnectionAcceptor() {
                return new ServerTransport.ConnectionAcceptor(){
                    private final ServerSetup serverSetup;
                    {
                        this.serverSetup = ServerStart.this.serverSetup();
                    }

                    @Override
                    public Mono<Void> apply(DuplexConnection connection) {
                        return ServerStart.this.acceptor(this.serverSetup, connection);
                    }
                };
            }

            @Override
            public <T extends Closeable> Start<T> transport(Supplier<ServerTransport<T>> transport) {
                this.transportServer = transport;
                return this::start;
            }

            private Mono<Void> acceptor(ServerSetup serverSetup, DuplexConnection connection) {
                ClientServerInputMultiplexer multiplexer = new ClientServerInputMultiplexer(connection, ServerRSocketFactory.this.plugins, false);
                return multiplexer.asSetupConnection().receive().next().flatMap(startFrame -> this.accept(serverSetup, (ByteBuf)startFrame, multiplexer));
            }

            private Mono<Void> acceptResume(ServerSetup serverSetup, ByteBuf resumeFrame, ClientServerInputMultiplexer multiplexer) {
                return serverSetup.acceptRSocketResume(resumeFrame, multiplexer);
            }

            private Mono<Void> accept(ServerSetup serverSetup, ByteBuf startFrame, ClientServerInputMultiplexer multiplexer) {
                switch (FrameHeaderFlyweight.frameType(startFrame)) {
                    case SETUP: {
                        return this.acceptSetup(serverSetup, startFrame, multiplexer);
                    }
                    case RESUME: {
                        return this.acceptResume(serverSetup, startFrame, multiplexer);
                    }
                }
                return this.acceptUnknown(startFrame, multiplexer);
            }

            private Mono<Void> acceptSetup(ServerSetup serverSetup, ByteBuf setupFrame, ClientServerInputMultiplexer multiplexer) {
                if (!SetupFrameFlyweight.isSupportedVersion(setupFrame)) {
                    return this.sendError(multiplexer, new InvalidSetupException("Unsupported version: " + SetupFrameFlyweight.humanReadableVersion(setupFrame))).doFinally(signalType -> {
                        setupFrame.release();
                        multiplexer.dispose();
                    });
                }
                boolean isLeaseEnabled = ServerRSocketFactory.this.leaseEnabled;
                if (SetupFrameFlyweight.honorLease(setupFrame) && !isLeaseEnabled) {
                    return this.sendError(multiplexer, new InvalidSetupException("lease is not supported")).doFinally(signalType -> {
                        setupFrame.release();
                        multiplexer.dispose();
                    });
                }
                return serverSetup.acceptRSocketSetup(setupFrame, multiplexer, (keepAliveHandler, wrappedMultiplexer) -> {
                    ConnectionSetupPayload setupPayload = ConnectionSetupPayload.create(setupFrame);
                    Leases leases = (Leases)ServerRSocketFactory.this.leasesSupplier.get();
                    RequesterLeaseHandler requesterLeaseHandler = isLeaseEnabled ? new RequesterLeaseHandler.Impl(ServerRSocketFactory.SERVER_TAG, leases.receiver()) : RequesterLeaseHandler.None;
                    RSocket rSocketRequester = new RSocketRequester(ServerRSocketFactory.this.allocator, wrappedMultiplexer.asServerConnection(), ServerRSocketFactory.this.payloadDecoder, ServerRSocketFactory.this.errorConsumer, StreamIdSupplier.serverSupplier(), setupPayload.keepAliveInterval(), setupPayload.keepAliveMaxLifetime(), (KeepAliveHandler)keepAliveHandler, requesterLeaseHandler);
                    if (ServerRSocketFactory.this.multiSubscriberRequester) {
                        rSocketRequester = new MultiSubscriberRSocket(rSocketRequester);
                    }
                    RSocket wrappedRSocketRequester = ServerRSocketFactory.this.plugins.applyRequester(rSocketRequester);
                    return ServerRSocketFactory.this.plugins.applySocketAcceptorInterceptor(ServerRSocketFactory.this.acceptor).accept(setupPayload, wrappedRSocketRequester).onErrorResume(err -> this.sendError(multiplexer, this.rejectedSetupError((Throwable)err)).then(Mono.error((Throwable)err))).doOnNext(rSocketHandler -> {
                        RSocket wrappedRSocketHandler = ServerRSocketFactory.this.plugins.applyResponder((RSocket)rSocketHandler);
                        ResponderLeaseHandler responderLeaseHandler = isLeaseEnabled ? new ResponderLeaseHandler.Impl<LeaseStats>(ServerRSocketFactory.SERVER_TAG, ServerRSocketFactory.this.allocator, leases.sender(), ServerRSocketFactory.this.errorConsumer, leases.stats()) : ResponderLeaseHandler.None;
                        RSocketResponder rSocketResponder = new RSocketResponder(ServerRSocketFactory.this.allocator, wrappedMultiplexer.asClientConnection(), wrappedRSocketHandler, ServerRSocketFactory.this.payloadDecoder, ServerRSocketFactory.this.errorConsumer, responderLeaseHandler);
                    }).doFinally(signalType -> setupPayload.release()).then();
                });
            }

            @Override
            public Mono<T> start() {
                return Mono.defer((Supplier)new Supplier<Mono<T>>(){
                    ServerSetup serverSetup;
                    {
                        this.serverSetup = ServerStart.this.serverSetup();
                    }

                    @Override
                    public Mono<T> get() {
                        return ((ServerTransport)ServerStart.this.transportServer.get()).start(duplexConnection -> ServerStart.this.acceptor(this.serverSetup, duplexConnection), ServerRSocketFactory.this.mtu).doOnNext(c -> c.onClose().doFinally(v -> this.serverSetup.dispose()).subscribe());
                    }
                });
            }

            private ServerSetup serverSetup() {
                return ServerRSocketFactory.this.resumeSupported ? new ServerSetup.ResumableServerSetup(ServerRSocketFactory.this.allocator, new SessionManager(), ServerRSocketFactory.this.resumeSessionDuration, ServerRSocketFactory.this.resumeStreamTimeout, ServerRSocketFactory.this.resumeStoreFactory, ServerRSocketFactory.this.resumeCleanupStoreOnKeepAlive) : new ServerSetup.DefaultServerSetup(ServerRSocketFactory.this.allocator);
            }

            private Mono<Void> acceptUnknown(ByteBuf frame, ClientServerInputMultiplexer multiplexer) {
                return this.sendError(multiplexer, new InvalidSetupException("invalid setup frame: " + (Object)((Object)FrameHeaderFlyweight.frameType(frame)))).doFinally(signalType -> {
                    frame.release();
                    multiplexer.dispose();
                });
            }

            private Mono<Void> sendError(ClientServerInputMultiplexer multiplexer, Exception exception) {
                return ConnectionUtils.sendError(ServerRSocketFactory.this.allocator, multiplexer, exception);
            }

            private Exception rejectedSetupError(Throwable err) {
                String msg = err.getMessage();
                return new RejectedSetupException(msg == null ? "rejected by server acceptor" : msg);
            }
        }
    }

    public static class ClientRSocketFactory
    implements ClientTransportAcceptor {
        private static final String CLIENT_TAG = "client";
        private SocketAcceptor acceptor = (setup, sendingSocket) -> Mono.just((Object)new AbstractRSocket(){});
        private Consumer<Throwable> errorConsumer = Throwable::printStackTrace;
        private int mtu = 0;
        private PluginRegistry plugins = new PluginRegistry(Plugins.defaultPlugins());
        private Payload setupPayload = EmptyPayload.INSTANCE;
        private PayloadDecoder payloadDecoder = PayloadDecoder.DEFAULT;
        private Duration tickPeriod = Duration.ofSeconds(20L);
        private Duration ackTimeout = Duration.ofSeconds(30L);
        private int missedAcks = 3;
        private String metadataMimeType = "application/binary";
        private String dataMimeType = "application/binary";
        private boolean resumeEnabled;
        private boolean resumeCleanupStoreOnKeepAlive;
        private Supplier<ByteBuf> resumeTokenSupplier = ResumeFrameFlyweight::generateResumeToken;
        private Function<? super ByteBuf, ? extends ResumableFramesStore> resumeStoreFactory = token -> new InMemoryResumableFramesStore(CLIENT_TAG, 100000);
        private Duration resumeSessionDuration = Duration.ofMinutes(2L);
        private Duration resumeStreamTimeout = Duration.ofSeconds(10L);
        private Supplier<ResumeStrategy> resumeStrategySupplier = () -> new ExponentialBackoffResumeStrategy(Duration.ofSeconds(1L), Duration.ofSeconds(16L), 2);
        private boolean multiSubscriberRequester = true;
        private boolean leaseEnabled;
        private Supplier<Leases<?>> leasesSupplier = Leases::new;
        private ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;

        public ClientRSocketFactory byteBufAllocator(ByteBufAllocator allocator) {
            Objects.requireNonNull(allocator);
            this.allocator = allocator;
            return this;
        }

        public ClientRSocketFactory addConnectionPlugin(DuplexConnectionInterceptor interceptor) {
            this.plugins.addConnectionPlugin(interceptor);
            return this;
        }

        @Deprecated
        public ClientRSocketFactory addClientPlugin(RSocketInterceptor interceptor) {
            return this.addRequesterPlugin(interceptor);
        }

        public ClientRSocketFactory addRequesterPlugin(RSocketInterceptor interceptor) {
            this.plugins.addRequesterPlugin(interceptor);
            return this;
        }

        @Deprecated
        public ClientRSocketFactory addServerPlugin(RSocketInterceptor interceptor) {
            return this.addResponderPlugin(interceptor);
        }

        public ClientRSocketFactory addResponderPlugin(RSocketInterceptor interceptor) {
            this.plugins.addResponderPlugin(interceptor);
            return this;
        }

        public ClientRSocketFactory addSocketAcceptorPlugin(SocketAcceptorInterceptor interceptor) {
            this.plugins.addSocketAcceptorPlugin(interceptor);
            return this;
        }

        @Deprecated
        public ClientRSocketFactory keepAlive() {
            return this;
        }

        public ClientRSocketFactory keepAlive(Duration tickPeriod, Duration ackTimeout, int missedAcks) {
            this.tickPeriod = tickPeriod;
            this.ackTimeout = ackTimeout;
            this.missedAcks = missedAcks;
            return this;
        }

        public ClientRSocketFactory keepAliveTickPeriod(Duration tickPeriod) {
            this.tickPeriod = tickPeriod;
            return this;
        }

        public ClientRSocketFactory keepAliveAckTimeout(Duration ackTimeout) {
            this.ackTimeout = ackTimeout;
            return this;
        }

        public ClientRSocketFactory keepAliveMissedAcks(int missedAcks) {
            this.missedAcks = missedAcks;
            return this;
        }

        public ClientRSocketFactory mimeType(String metadataMimeType, String dataMimeType) {
            this.dataMimeType = dataMimeType;
            this.metadataMimeType = metadataMimeType;
            return this;
        }

        public ClientRSocketFactory dataMimeType(String dataMimeType) {
            this.dataMimeType = dataMimeType;
            return this;
        }

        public ClientRSocketFactory metadataMimeType(String metadataMimeType) {
            this.metadataMimeType = metadataMimeType;
            return this;
        }

        public ClientRSocketFactory lease(Supplier<Leases<? extends LeaseStats>> leasesSupplier) {
            this.leaseEnabled = true;
            this.leasesSupplier = Objects.requireNonNull(leasesSupplier);
            return this;
        }

        public ClientRSocketFactory lease() {
            this.leaseEnabled = true;
            return this;
        }

        public ClientRSocketFactory singleSubscriberRequester() {
            this.multiSubscriberRequester = false;
            return this;
        }

        public ClientRSocketFactory resume() {
            this.resumeEnabled = true;
            return this;
        }

        public ClientRSocketFactory resumeToken(Supplier<ByteBuf> resumeTokenSupplier) {
            this.resumeTokenSupplier = Objects.requireNonNull(resumeTokenSupplier);
            return this;
        }

        public ClientRSocketFactory resumeStore(Function<? super ByteBuf, ? extends ResumableFramesStore> resumeStoreFactory) {
            this.resumeStoreFactory = resumeStoreFactory;
            return this;
        }

        public ClientRSocketFactory resumeSessionDuration(Duration sessionDuration) {
            this.resumeSessionDuration = Objects.requireNonNull(sessionDuration);
            return this;
        }

        public ClientRSocketFactory resumeStreamTimeout(Duration resumeStreamTimeout) {
            this.resumeStreamTimeout = Objects.requireNonNull(resumeStreamTimeout);
            return this;
        }

        public ClientRSocketFactory resumeStrategy(Supplier<ResumeStrategy> resumeStrategy) {
            this.resumeStrategySupplier = Objects.requireNonNull(resumeStrategy);
            return this;
        }

        public ClientRSocketFactory resumeCleanupOnKeepAlive() {
            this.resumeCleanupStoreOnKeepAlive = true;
            return this;
        }

        @Override
        public Start<RSocket> transport(Supplier<ClientTransport> transportClient) {
            return new StartClient(transportClient);
        }

        public ClientTransportAcceptor acceptor(Function<RSocket, RSocket> acceptor) {
            return this.acceptor(() -> acceptor);
        }

        public ClientTransportAcceptor acceptor(Supplier<Function<RSocket, RSocket>> acceptor) {
            return this.acceptor((ConnectionSetupPayload setup, RSocket sendingSocket) -> Mono.just(((Function)acceptor.get()).apply(sendingSocket)));
        }

        @Deprecated
        public ClientTransportAcceptor acceptor(BiFunction<ConnectionSetupPayload, RSocket, RSocket> biAcceptor) {
            return this.acceptor((ConnectionSetupPayload setup, RSocket sendingSocket) -> Mono.just(biAcceptor.apply(setup, sendingSocket)));
        }

        public ClientTransportAcceptor acceptor(SocketAcceptor acceptor) {
            this.acceptor = acceptor;
            return x$0 -> new StartClient(x$0);
        }

        public ClientRSocketFactory fragment(int mtu) {
            this.mtu = mtu;
            return this;
        }

        public ClientRSocketFactory errorConsumer(Consumer<Throwable> errorConsumer) {
            this.errorConsumer = errorConsumer;
            return this;
        }

        public ClientRSocketFactory setupPayload(Payload payload) {
            this.setupPayload = payload;
            return this;
        }

        public ClientRSocketFactory frameDecoder(PayloadDecoder payloadDecoder) {
            this.payloadDecoder = payloadDecoder;
            return this;
        }

        private class StartClient
        implements Start<RSocket> {
            private final Supplier<ClientTransport> transportClient;

            StartClient(Supplier<ClientTransport> transportClient) {
                this.transportClient = transportClient;
            }

            @Override
            public Mono<RSocket> start() {
                return this.newConnection().flatMap(connection -> {
                    ClientSetup clientSetup = this.clientSetup((DuplexConnection)connection);
                    ByteBuf resumeToken = clientSetup.resumeToken();
                    KeepAliveHandler keepAliveHandler = clientSetup.keepAliveHandler();
                    DuplexConnection wrappedConnection = clientSetup.connection();
                    ClientServerInputMultiplexer multiplexer = new ClientServerInputMultiplexer(wrappedConnection, ClientRSocketFactory.this.plugins, true);
                    boolean isLeaseEnabled = ClientRSocketFactory.this.leaseEnabled;
                    Leases leases = (Leases)ClientRSocketFactory.this.leasesSupplier.get();
                    RequesterLeaseHandler requesterLeaseHandler = isLeaseEnabled ? new RequesterLeaseHandler.Impl(ClientRSocketFactory.CLIENT_TAG, leases.receiver()) : RequesterLeaseHandler.None;
                    RSocket rSocketRequester = new RSocketRequester(ClientRSocketFactory.this.allocator, multiplexer.asClientConnection(), ClientRSocketFactory.this.payloadDecoder, ClientRSocketFactory.this.errorConsumer, StreamIdSupplier.clientSupplier(), this.keepAliveTickPeriod(), this.keepAliveTimeout(), keepAliveHandler, requesterLeaseHandler);
                    if (ClientRSocketFactory.this.multiSubscriberRequester) {
                        rSocketRequester = new MultiSubscriberRSocket(rSocketRequester);
                    }
                    RSocket wrappedRSocketRequester = ClientRSocketFactory.this.plugins.applyRequester(rSocketRequester);
                    ByteBuf setupFrame = SetupFrameFlyweight.encode(ClientRSocketFactory.this.allocator, isLeaseEnabled, this.keepAliveTickPeriod(), this.keepAliveTimeout(), resumeToken, ClientRSocketFactory.this.metadataMimeType, ClientRSocketFactory.this.dataMimeType, ClientRSocketFactory.this.setupPayload);
                    ConnectionSetupPayload setup = ConnectionSetupPayload.create(setupFrame);
                    return ClientRSocketFactory.this.plugins.applySocketAcceptorInterceptor(ClientRSocketFactory.this.acceptor).accept(setup, wrappedRSocketRequester).flatMap(rSocketHandler -> {
                        RSocket wrappedRSocketHandler = ClientRSocketFactory.this.plugins.applyResponder((RSocket)rSocketHandler);
                        ResponderLeaseHandler responderLeaseHandler = isLeaseEnabled ? new ResponderLeaseHandler.Impl<LeaseStats>(ClientRSocketFactory.CLIENT_TAG, ClientRSocketFactory.this.allocator, leases.sender(), ClientRSocketFactory.this.errorConsumer, leases.stats()) : ResponderLeaseHandler.None;
                        RSocketResponder rSocketResponder = new RSocketResponder(ClientRSocketFactory.this.allocator, multiplexer.asServerConnection(), wrappedRSocketHandler, ClientRSocketFactory.this.payloadDecoder, ClientRSocketFactory.this.errorConsumer, responderLeaseHandler);
                        return wrappedConnection.sendOne(setupFrame).thenReturn((Object)wrappedRSocketRequester);
                    });
                });
            }

            private int keepAliveTickPeriod() {
                return (int)ClientRSocketFactory.this.tickPeriod.toMillis();
            }

            private int keepAliveTimeout() {
                return (int)(ClientRSocketFactory.this.ackTimeout.toMillis() + ClientRSocketFactory.this.tickPeriod.toMillis() * (long)ClientRSocketFactory.this.missedAcks);
            }

            private ClientSetup clientSetup(DuplexConnection startConnection) {
                if (ClientRSocketFactory.this.resumeEnabled) {
                    ByteBuf resumeToken = (ByteBuf)ClientRSocketFactory.this.resumeTokenSupplier.get();
                    return new ClientSetup.ResumableClientSetup(ClientRSocketFactory.this.allocator, startConnection, this.newConnection(), resumeToken, (ResumableFramesStore)ClientRSocketFactory.this.resumeStoreFactory.apply(resumeToken), ClientRSocketFactory.this.resumeSessionDuration, ClientRSocketFactory.this.resumeStreamTimeout, ClientRSocketFactory.this.resumeStrategySupplier, ClientRSocketFactory.this.resumeCleanupStoreOnKeepAlive);
                }
                return new ClientSetup.DefaultClientSetup(startConnection);
            }

            private Mono<DuplexConnection> newConnection() {
                return this.transportClient.get().connect(ClientRSocketFactory.this.mtu);
            }
        }
    }

    public static interface ServerTransportAcceptor {
        public ServerTransport.ConnectionAcceptor toConnectionAcceptor();

        public <T extends Closeable> Start<T> transport(Supplier<ServerTransport<T>> var1);

        default public <T extends Closeable> Start<T> transport(ServerTransport<T> transport) {
            return this.transport(() -> transport);
        }
    }

    public static interface ClientTransportAcceptor {
        public Start<RSocket> transport(Supplier<ClientTransport> var1);

        default public Start<RSocket> transport(ClientTransport transport) {
            return this.transport(() -> transport);
        }
    }

    public static interface Start<T extends Closeable> {
        public Mono<T> start();
    }
}

