/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.plugins;

import io.rsocket.DuplexConnection;
import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.RSocketInterceptor;
import io.rsocket.plugins.SocketAcceptorInterceptor;
import java.util.ArrayList;
import java.util.List;

public class PluginRegistry {
    private List<DuplexConnectionInterceptor> connections = new ArrayList<DuplexConnectionInterceptor>();
    private List<RSocketInterceptor> requesters = new ArrayList<RSocketInterceptor>();
    private List<RSocketInterceptor> responders = new ArrayList<RSocketInterceptor>();
    private List<SocketAcceptorInterceptor> socketAcceptorInterceptors = new ArrayList<SocketAcceptorInterceptor>();

    public PluginRegistry() {
    }

    public PluginRegistry(PluginRegistry defaults) {
        this.connections.addAll(defaults.connections);
        this.requesters.addAll(defaults.requesters);
        this.responders.addAll(defaults.responders);
    }

    public void addConnectionPlugin(DuplexConnectionInterceptor interceptor) {
        this.connections.add(interceptor);
    }

    @Deprecated
    public void addClientPlugin(RSocketInterceptor interceptor) {
        this.addRequesterPlugin(interceptor);
    }

    public void addRequesterPlugin(RSocketInterceptor interceptor) {
        this.requesters.add(interceptor);
    }

    @Deprecated
    public void addServerPlugin(RSocketInterceptor interceptor) {
        this.addResponderPlugin(interceptor);
    }

    public void addResponderPlugin(RSocketInterceptor interceptor) {
        this.responders.add(interceptor);
    }

    public void addSocketAcceptorPlugin(SocketAcceptorInterceptor interceptor) {
        this.socketAcceptorInterceptors.add(interceptor);
    }

    @Deprecated
    public RSocket applyClient(RSocket rSocket) {
        return this.applyRequester(rSocket);
    }

    public RSocket applyRequester(RSocket rSocket) {
        for (RSocketInterceptor i : this.requesters) {
            rSocket = (RSocket)i.apply(rSocket);
        }
        return rSocket;
    }

    @Deprecated
    public RSocket applyServer(RSocket rSocket) {
        return this.applyResponder(rSocket);
    }

    public RSocket applyResponder(RSocket rSocket) {
        for (RSocketInterceptor i : this.responders) {
            rSocket = (RSocket)i.apply(rSocket);
        }
        return rSocket;
    }

    public SocketAcceptor applySocketAcceptorInterceptor(SocketAcceptor acceptor) {
        for (SocketAcceptorInterceptor i : this.socketAcceptorInterceptors) {
            acceptor = (SocketAcceptor)i.apply(acceptor);
        }
        return acceptor;
    }

    public DuplexConnection applyConnection(DuplexConnectionInterceptor.Type type, DuplexConnection connection) {
        for (DuplexConnectionInterceptor i : this.connections) {
            connection = (DuplexConnection)i.apply(type, connection);
        }
        return connection;
    }
}

