/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.rsocket.core.Invalidatable;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class ReconnectMono<T>
extends Mono<T>
implements Invalidatable,
Disposable,
Scannable {
    final Mono<T> source;
    final BiConsumer<? super T, Invalidatable> onValueReceived;
    final Consumer<? super T> onValueExpired;
    final ReconnectMainSubscriber<? super T> mainSubscriber;
    volatile int wip;
    static final AtomicIntegerFieldUpdater<ReconnectMono> WIP = AtomicIntegerFieldUpdater.newUpdater(ReconnectMono.class, "wip");
    volatile ReconnectInner<T>[] subscribers;
    static final AtomicReferenceFieldUpdater<ReconnectMono, ReconnectInner[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(ReconnectMono.class, ReconnectInner[].class, "subscribers");
    static final ReconnectInner[] EMPTY_UNSUBSCRIBED = new ReconnectInner[0];
    static final ReconnectInner[] EMPTY_SUBSCRIBED = new ReconnectInner[0];
    static final ReconnectInner[] READY = new ReconnectInner[0];
    static final ReconnectInner[] TERMINATED = new ReconnectInner[0];
    static final int ADDED_STATE = 0;
    static final int READY_STATE = 1;
    static final int TERMINATED_STATE = 2;
    T value;
    Throwable t;

    ReconnectMono(Mono<T> source, Consumer<? super T> onValueExpired, BiConsumer<? super T, Invalidatable> onValueReceived) {
        this.source = source;
        this.onValueExpired = onValueExpired;
        this.onValueReceived = onValueReceived;
        this.mainSubscriber = new ReconnectMainSubscriber(this);
        SUBSCRIBERS.lazySet(this, EMPTY_UNSUBSCRIBED);
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return Integer.MAX_VALUE;
        }
        boolean isDisposed = this.isDisposed();
        if (key == Scannable.Attr.TERMINATED) {
            return isDisposed;
        }
        if (key == Scannable.Attr.ERROR) {
            return this.t;
        }
        return null;
    }

    public void dispose() {
        this.terminate(new CancellationException("ReconnectMono has already been disposed"));
    }

    public boolean isDisposed() {
        return this.subscribers == TERMINATED;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        ReconnectInner<? super T> inner = new ReconnectInner<T>(actual, this);
        actual.onSubscribe(inner);
        int state = this.add(inner);
        if (state == 1) {
            inner.complete(this.value);
        } else if (state == 2) {
            inner.onError(this.t);
        }
    }

    @Nullable
    public T block() {
        return this.block(null);
    }

    @Nullable
    public T block(@Nullable Duration timeout) {
        try {
            ReconnectInner<T>[] subscribers = this.subscribers;
            if (subscribers == READY) {
                return this.value;
            }
            if (subscribers == TERMINATED) {
                RuntimeException re = Exceptions.propagate((Throwable)this.t);
                re = Exceptions.addSuppressed((RuntimeException)re, (Throwable)new Exception("ReconnectMono terminated with an error"));
                throw re;
            }
            if (subscribers == EMPTY_UNSUBSCRIBED && SUBSCRIBERS.compareAndSet(this, EMPTY_UNSUBSCRIBED, EMPTY_SUBSCRIBED)) {
                this.source.subscribe(this.mainSubscriber);
            }
            long delay = null == timeout ? 0L : System.nanoTime() + timeout.toNanos();
            while (true) {
                ReconnectInner<T>[] inners;
                if ((inners = this.subscribers) == READY) {
                    return this.value;
                }
                if (inners == TERMINATED) {
                    RuntimeException re = Exceptions.propagate((Throwable)this.t);
                    re = Exceptions.addSuppressed((RuntimeException)re, (Throwable)new Exception("ReconnectMono terminated with an error"));
                    throw re;
                }
                if (timeout != null && delay < System.nanoTime()) {
                    throw new IllegalStateException("Timeout on Mono blocking read");
                }
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread Interruption on Mono blocking read");
        }
    }

    void terminate(Throwable t) {
        if (this.isDisposed()) {
            return;
        }
        this.t = t;
        ReconnectInner[] subscribers = SUBSCRIBERS.getAndSet(this, TERMINATED);
        if (subscribers == TERMINATED) {
            Operators.onErrorDropped((Throwable)t, (Context)Context.empty());
            return;
        }
        this.mainSubscriber.dispose();
        this.doFinally();
        for (ReconnectInner consumer : subscribers) {
            consumer.onError(t);
        }
    }

    void complete() {
        ReconnectInner<T>[] subscribers = this.subscribers;
        if (subscribers == TERMINATED) {
            return;
        }
        T value = this.value;
        while (!SUBSCRIBERS.compareAndSet(this, subscribers, READY)) {
            subscribers = this.subscribers;
            if (subscribers != TERMINATED) continue;
            this.doFinally();
            return;
        }
        this.onValueReceived.accept(value, this);
        for (ReconnectInner<T> consumer : subscribers) {
            consumer.complete(value);
        }
    }

    void doFinally() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int m = 1;
        do {
            T value;
            if ((value = this.value) == null || !this.isDisposed()) continue;
            this.value = null;
            this.onValueExpired.accept(value);
            return;
        } while ((m = WIP.addAndGet(this, -m)) != 0);
    }

    @Override
    public void invalidate() {
        if (this.subscribers == TERMINATED) {
            return;
        }
        ReconnectInner<T>[] subscribers = this.subscribers;
        if (subscribers == READY && SUBSCRIBERS.compareAndSet(this, READY, EMPTY_UNSUBSCRIBED)) {
            T value = this.value;
            this.value = null;
            if (value != null) {
                this.onValueExpired.accept(value);
            }
        }
    }

    int add(ReconnectInner<T> ps) {
        ReconnectInner[] b;
        ReconnectInner<T>[] a;
        do {
            if ((a = this.subscribers) == TERMINATED) {
                return 2;
            }
            if (a == READY) {
                return 1;
            }
            int n = a.length;
            b = new ReconnectInner[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        if (a == EMPTY_UNSUBSCRIBED) {
            this.source.subscribe(this.mainSubscriber);
        }
        return 0;
    }

    void remove(ReconnectInner<T> ps) {
        ReconnectInner[] b;
        ReconnectInner<T>[] a;
        do {
            int n;
            if ((n = (a = this.subscribers).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY_SUBSCRIBED;
                continue;
            }
            b = new ReconnectInner[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
    }

    static final class ReconnectInner<T>
    extends Operators.MonoSubscriber<T, T> {
        final ReconnectMono<T> parent;

        ReconnectInner(CoreSubscriber<? super T> actual, ReconnectMono<T> parent) {
            super(actual);
            this.parent = parent;
        }

        public void cancel() {
            if (!this.isCancelled()) {
                super.cancel();
                this.parent.remove(this);
            }
        }

        public void onComplete() {
            if (!this.isCancelled()) {
                this.actual.onComplete();
            }
        }

        public void onError(Throwable t) {
            if (this.isCancelled()) {
                Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
            } else {
                this.actual.onError(t);
            }
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            return super.scanUnsafe(key);
        }
    }

    static final class ReconnectMainSubscriber<T>
    implements CoreSubscriber<T> {
        final ReconnectMono<T> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ReconnectMainSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ReconnectMainSubscriber.class, Subscription.class, "s");

        ReconnectMainSubscriber(ReconnectMono<T> parent) {
            this.parent = parent;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, (Object)this, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onComplete() {
            Subscription s = this.s;
            ReconnectMono<T> p = this.parent;
            Object value = p.value;
            if (s == Operators.cancelledSubscription() || !S.compareAndSet(this, s, null)) {
                p.doFinally();
                return;
            }
            if (value == null) {
                p.terminate(new IllegalStateException("Unexpected Completion of the Upstream"));
            } else {
                p.complete();
            }
        }

        public void onError(Throwable t) {
            Subscription s = this.s;
            ReconnectMono<T> p = this.parent;
            if (s == Operators.cancelledSubscription() || S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
                p.doFinally();
                Operators.onErrorDropped((Throwable)t, (Context)Context.empty());
                return;
            }
            p.terminate(t);
        }

        public void onNext(T value) {
            if (this.s == Operators.cancelledSubscription()) {
                this.parent.onValueExpired.accept(value);
                return;
            }
            ReconnectMono<T> p = this.parent;
            p.value = value;
            p.doFinally();
        }

        void dispose() {
            Operators.terminate(S, (Object)this);
        }
    }
}

