/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import reactor.util.annotation.Nullable;

public class RSocketErrorException
extends RuntimeException {
    private static final long serialVersionUID = -1628781753426267554L;
    private static final int MIN_ERROR_CODE = 1;
    private static final int MAX_ERROR_CODE = -2;
    private final int errorCode;

    public RSocketErrorException(int errorCode, String message) {
        this(errorCode, message, null);
    }

    public RSocketErrorException(int errorCode, String message, @Nullable Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
        if (errorCode > -2 && errorCode < 1) {
            throw new IllegalArgumentException("Allowed errorCode value should be in range [0x00000001-0xFFFFFFFE]", this);
        }
    }

    public int errorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " (0x" + Integer.toHexString(this.errorCode) + "): " + this.getMessage();
    }
}

