/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.fragmentation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.rsocket.frame.FragmentationCodec;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.RequestChannelFrameCodec;
import io.rsocket.frame.RequestFireAndForgetFrameCodec;
import io.rsocket.frame.RequestResponseFrameCodec;
import io.rsocket.frame.RequestStreamFrameCodec;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;

final class FrameReassembler
extends AtomicBoolean
implements Disposable {
    private static final long serialVersionUID = -4394598098863449055L;
    private static final Logger logger = LoggerFactory.getLogger(FrameReassembler.class);
    final IntObjectMap<ByteBuf> headers;
    final IntObjectMap<CompositeByteBuf> metadata;
    final IntObjectMap<CompositeByteBuf> data;
    private final ByteBufAllocator allocator;

    public FrameReassembler(ByteBufAllocator allocator) {
        this.allocator = allocator;
        this.headers = new IntObjectHashMap();
        this.metadata = new IntObjectHashMap();
        this.data = new IntObjectHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.compareAndSet(false, true)) {
            FrameReassembler frameReassembler = this;
            synchronized (frameReassembler) {
                for (ByteBuf byteBuf : this.headers.values()) {
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                }
                this.headers.clear();
                for (ByteBuf byteBuf : this.metadata.values()) {
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                }
                this.metadata.clear();
                for (ByteBuf byteBuf : this.data.values()) {
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                }
                this.data.clear();
            }
        }
    }

    public boolean isDisposed() {
        return this.get();
    }

    @Nullable
    synchronized ByteBuf getHeader(int streamId) {
        return (ByteBuf)this.headers.get(streamId);
    }

    synchronized CompositeByteBuf getMetadata(int streamId) {
        CompositeByteBuf byteBuf = (CompositeByteBuf)this.metadata.get(streamId);
        if (byteBuf == null) {
            byteBuf = this.allocator.compositeBuffer();
            this.metadata.put(streamId, (Object)byteBuf);
        }
        return byteBuf;
    }

    synchronized CompositeByteBuf getData(int streamId) {
        CompositeByteBuf byteBuf = (CompositeByteBuf)this.data.get(streamId);
        if (byteBuf == null) {
            byteBuf = this.allocator.compositeBuffer();
            this.data.put(streamId, (Object)byteBuf);
        }
        return byteBuf;
    }

    @Nullable
    synchronized ByteBuf removeHeader(int streamId) {
        return (ByteBuf)this.headers.remove(streamId);
    }

    @Nullable
    synchronized CompositeByteBuf removeMetadata(int streamId) {
        return (CompositeByteBuf)this.metadata.remove(streamId);
    }

    @Nullable
    synchronized CompositeByteBuf removeData(int streamId) {
        return (CompositeByteBuf)this.data.remove(streamId);
    }

    synchronized void putHeader(int streamId, ByteBuf header) {
        this.headers.put(streamId, (Object)header);
    }

    void cancelAssemble(int streamId) {
        ByteBuf header = this.removeHeader(streamId);
        CompositeByteBuf metadata = this.removeMetadata(streamId);
        CompositeByteBuf data = this.removeData(streamId);
        if (header != null) {
            ReferenceCountUtil.safeRelease((Object)header);
        }
        if (metadata != null) {
            ReferenceCountUtil.safeRelease((Object)metadata);
        }
        if (data != null) {
            ReferenceCountUtil.safeRelease((Object)data);
        }
    }

    void handleNoFollowsFlag(ByteBuf frame, SynchronousSink<ByteBuf> sink, int streamId) {
        ByteBuf header = this.removeHeader(streamId);
        if (header != null) {
            if (FrameHeaderCodec.hasMetadata(header)) {
                ByteBuf assembledFrame = this.assembleFrameWithMetadata(frame, streamId, header);
                sink.next((Object)assembledFrame);
            } else {
                ByteBuf data = this.assembleData(frame, streamId);
                ByteBuf assembledFrame = FragmentationCodec.encode(this.allocator, header, data);
                sink.next((Object)assembledFrame);
            }
            frame.release();
        } else {
            sink.next((Object)frame);
        }
    }

    void handleFollowsFlag(ByteBuf frame, int streamId, FrameType frameType) {
        ByteBuf data;
        ByteBuf header = this.getHeader(streamId);
        if (header == null) {
            header = frame.copy(frame.readerIndex(), FrameHeaderCodec.size());
            if (frameType == FrameType.REQUEST_CHANNEL || frameType == FrameType.REQUEST_STREAM) {
                long i = RequestChannelFrameCodec.initialRequestN(frame);
                header.writeInt(i > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)i);
            }
            this.putHeader(streamId, header);
        }
        if (FrameHeaderCodec.hasMetadata(frame)) {
            CompositeByteBuf metadata = this.getMetadata(streamId);
            switch (frameType) {
                case REQUEST_FNF: {
                    metadata.addComponents(true, new ByteBuf[]{RequestFireAndForgetFrameCodec.metadata(frame).retain()});
                    break;
                }
                case REQUEST_STREAM: {
                    metadata.addComponents(true, new ByteBuf[]{RequestStreamFrameCodec.metadata(frame).retain()});
                    break;
                }
                case REQUEST_RESPONSE: {
                    metadata.addComponents(true, new ByteBuf[]{RequestResponseFrameCodec.metadata(frame).retain()});
                    break;
                }
                case REQUEST_CHANNEL: {
                    metadata.addComponents(true, new ByteBuf[]{RequestChannelFrameCodec.metadata(frame).retain()});
                    break;
                }
                case PAYLOAD: 
                case NEXT: 
                case NEXT_COMPLETE: 
                case COMPLETE: {
                    metadata.addComponents(true, new ByteBuf[]{PayloadFrameCodec.metadata(frame).retain()});
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported fragment type");
                }
            }
        }
        switch (frameType) {
            case REQUEST_FNF: {
                data = RequestFireAndForgetFrameCodec.data(frame).retain();
                break;
            }
            case REQUEST_STREAM: {
                data = RequestStreamFrameCodec.data(frame).retain();
                break;
            }
            case REQUEST_RESPONSE: {
                data = RequestResponseFrameCodec.data(frame).retain();
                break;
            }
            case REQUEST_CHANNEL: {
                data = RequestChannelFrameCodec.data(frame).retain();
                break;
            }
            case PAYLOAD: 
            case NEXT: 
            case NEXT_COMPLETE: 
            case COMPLETE: {
                data = PayloadFrameCodec.data(frame).retain();
                break;
            }
            default: {
                throw new IllegalStateException("unsupported fragment type");
            }
        }
        this.getData(streamId).addComponents(true, new ByteBuf[]{data});
        frame.release();
    }

    void reassembleFrame(ByteBuf frame, SynchronousSink<ByteBuf> sink) {
        try {
            FrameType frameType = FrameHeaderCodec.frameType(frame);
            int streamId = FrameHeaderCodec.streamId(frame);
            switch (frameType) {
                case CANCEL: 
                case ERROR: {
                    this.cancelAssemble(streamId);
                }
            }
            if (!frameType.isFragmentable()) {
                sink.next((Object)frame);
                return;
            }
            boolean hasFollows = FrameHeaderCodec.hasFollows(frame);
            if (hasFollows) {
                this.handleFollowsFlag(frame, streamId, frameType);
            } else {
                this.handleNoFollowsFlag(frame, sink, streamId);
            }
        }
        catch (Throwable t) {
            logger.error("error reassemble frame", t);
            sink.error(t);
        }
    }

    private ByteBuf assembleFrameWithMetadata(ByteBuf frame, int streamId, ByteBuf header) {
        CompositeByteBuf cm = this.removeMetadata(streamId);
        ByteBuf decodedMetadata = PayloadFrameCodec.metadata(frame);
        Object metadata = decodedMetadata != null ? (cm != null ? cm.addComponents(true, new ByteBuf[]{decodedMetadata.retain()}) : PayloadFrameCodec.metadata(frame).retain()) : cm;
        ByteBuf data = this.assembleData(frame, streamId);
        return FragmentationCodec.encode(this.allocator, header, (ByteBuf)metadata, data);
    }

    private ByteBuf assembleData(ByteBuf frame, int streamId) {
        ByteBuf data;
        CompositeByteBuf cd = this.removeData(streamId);
        if (cd != null) {
            cd.addComponents(true, new ByteBuf[]{PayloadFrameCodec.data(frame).retain()});
            data = cd;
        } else {
            data = Unpooled.EMPTY_BUFFER;
        }
        return data;
    }
}

