/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.rsocket.Payload;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

abstract class RequestOperator
implements CoreSubscriber<Payload>,
CorePublisher<Payload>,
Fuseable.QueueSubscription<Payload>,
Fuseable {
    final CorePublisher<Payload> source;
    final String errorMessageOnSecondSubscription;
    CoreSubscriber<? super Payload> actual;
    Subscription s;
    Fuseable.QueueSubscription<Payload> qs;
    int streamId;
    boolean firstRequest = true;
    volatile int wip;
    static final AtomicIntegerFieldUpdater<RequestOperator> WIP = AtomicIntegerFieldUpdater.newUpdater(RequestOperator.class, "wip");

    RequestOperator(CorePublisher<Payload> source, String errorMessageOnSecondSubscription) {
        this.source = source;
        this.errorMessageOnSecondSubscription = errorMessageOnSecondSubscription;
        WIP.lazySet(this, -1);
    }

    public void subscribe(Subscriber<? super Payload> actual) {
        this.subscribe((CoreSubscriber<? super Payload>)Operators.toCoreSubscriber(actual));
    }

    public void subscribe(CoreSubscriber<? super Payload> actual) {
        if (this.wip == -1 && WIP.compareAndSet(this, -1, 0)) {
            this.actual = actual;
            this.source.subscribe((CoreSubscriber)this);
            actual.onSubscribe((Subscription)this);
        } else {
            Operators.error(actual, (Throwable)new IllegalStateException(this.errorMessageOnSecondSubscription));
        }
    }

    void hookOnFirstRequest(long n) {
    }

    void hookOnRemainingRequests(long n) {
    }

    void hookOnCancel() {
    }

    void hookOnTerminal(SignalType signalType) {
    }

    public Context currentContext() {
        return this.actual.currentContext();
    }

    public void request(long n) {
        if (!this.firstRequest) {
            try {
                this.hookOnRemainingRequests(n);
            }
            catch (Throwable throwable) {
                this.onError(throwable);
            }
            return;
        }
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        this.firstRequest = false;
        int missed = 1;
        boolean firstLoop = true;
        do {
            if (firstLoop) {
                firstLoop = false;
                try {
                    this.s.request(Long.MAX_VALUE);
                    this.hookOnFirstRequest(n);
                }
                catch (Throwable throwable) {
                    this.onError(throwable);
                    return;
                }
            }
            try {
                this.hookOnCancel();
            }
            catch (Throwable throwable) {
                this.onError(throwable);
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    public void cancel() {
        this.s.cancel();
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        this.hookOnCancel();
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.s, (Subscription)s)) {
            this.s = s;
            if (s instanceof Fuseable.QueueSubscription) {
                this.qs = (Fuseable.QueueSubscription)s;
            }
        }
    }

    public void onNext(Payload t) {
        this.actual.onNext((Object)t);
    }

    public void onError(Throwable t) {
        this.actual.onError(t);
        try {
            this.hookOnTerminal(SignalType.ON_ERROR);
        }
        catch (Throwable throwable) {
            Operators.onErrorDropped((Throwable)throwable, (Context)this.currentContext());
        }
    }

    public void onComplete() {
        this.actual.onComplete();
        try {
            this.hookOnTerminal(SignalType.ON_COMPLETE);
        }
        catch (Throwable throwable) {
            Operators.onErrorDropped((Throwable)throwable, (Context)this.currentContext());
        }
    }

    public int requestFusion(int requestedMode) {
        if (this.qs != null) {
            return this.qs.requestFusion(requestedMode);
        }
        return 0;
    }

    public Payload poll() {
        return (Payload)this.qs.poll();
    }

    public int size() {
        return this.qs.size();
    }

    public boolean isEmpty() {
        return this.qs.isEmpty();
    }

    public void clear() {
        this.qs.clear();
    }
}

