/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.fragmentation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.RequestChannelFrameCodec;
import io.rsocket.frame.RequestFireAndForgetFrameCodec;
import io.rsocket.frame.RequestResponseFrameCodec;
import io.rsocket.frame.RequestStreamFrameCodec;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;

final class FrameFragmenter {
    FrameFragmenter() {
    }

    static Publisher<ByteBuf> fragmentFrame(final ByteBufAllocator allocator, final int mtu, final ByteBuf frame, final FrameType frameType) {
        final ByteBuf metadata = FrameFragmenter.getMetadata(frame, frameType);
        final ByteBuf data = FrameFragmenter.getData(frame, frameType);
        final int streamId = FrameHeaderCodec.streamId(frame);
        return Flux.generate((Consumer)new Consumer<SynchronousSink<ByteBuf>>(){
            boolean first = true;

            @Override
            public void accept(SynchronousSink<ByteBuf> sink) {
                ByteBuf byteBuf;
                if (this.first) {
                    this.first = false;
                    byteBuf = FrameFragmenter.encodeFirstFragment(allocator, mtu, frame, frameType, streamId, metadata, data);
                } else {
                    byteBuf = FrameFragmenter.encodeFollowsFragment(allocator, mtu, streamId, metadata, data);
                }
                sink.next((Object)byteBuf);
                if (!metadata.isReadable() && !data.isReadable()) {
                    sink.complete();
                }
            }
        }).doFinally(signalType -> ReferenceCountUtil.safeRelease((Object)frame));
    }

    static ByteBuf encodeFirstFragment(ByteBufAllocator allocator, int mtu, ByteBuf frame, FrameType frameType, int streamId, ByteBuf metadata, ByteBuf data) {
        int remaining = mtu - FrameHeaderCodec.size();
        switch (frameType) {
            case REQUEST_STREAM: 
            case REQUEST_CHANNEL: {
                remaining -= 4;
                break;
            }
        }
        ByteBuf metadataFragment = null;
        if (metadata.isReadable()) {
            int r = Math.min(remaining -= 3, metadata.readableBytes());
            remaining -= r;
            metadataFragment = metadata.readRetainedSlice(r);
        }
        ByteBuf dataFragment = Unpooled.EMPTY_BUFFER;
        if (remaining > 0 && data.isReadable()) {
            int r = Math.min(remaining, data.readableBytes());
            dataFragment = data.readRetainedSlice(r);
        }
        switch (frameType) {
            case REQUEST_FNF: {
                return RequestFireAndForgetFrameCodec.encode(allocator, streamId, true, metadataFragment, dataFragment);
            }
            case REQUEST_STREAM: {
                return RequestStreamFrameCodec.encode(allocator, streamId, true, RequestStreamFrameCodec.initialRequestN(frame), metadataFragment, dataFragment);
            }
            case REQUEST_RESPONSE: {
                return RequestResponseFrameCodec.encode(allocator, streamId, true, metadataFragment, dataFragment);
            }
            case REQUEST_CHANNEL: {
                return RequestChannelFrameCodec.encode(allocator, streamId, true, false, RequestChannelFrameCodec.initialRequestN(frame), metadataFragment, dataFragment);
            }
            case PAYLOAD: {
                return PayloadFrameCodec.encode(allocator, streamId, true, false, false, metadataFragment, dataFragment);
            }
            case NEXT: {
                return PayloadFrameCodec.encode(allocator, streamId, true, false, true, metadataFragment, dataFragment);
            }
            case NEXT_COMPLETE: {
                return PayloadFrameCodec.encode(allocator, streamId, true, true, true, metadataFragment, dataFragment);
            }
            case COMPLETE: {
                return PayloadFrameCodec.encode(allocator, streamId, true, true, false, metadataFragment, dataFragment);
            }
        }
        throw new IllegalStateException("unsupported fragment type: " + (Object)((Object)frameType));
    }

    static ByteBuf encodeFollowsFragment(ByteBufAllocator allocator, int mtu, int streamId, ByteBuf metadata, ByteBuf data) {
        int remaining = mtu - FrameHeaderCodec.size();
        ByteBuf metadataFragment = null;
        if (metadata.isReadable()) {
            int r = Math.min(remaining -= 3, metadata.readableBytes());
            remaining -= r;
            metadataFragment = metadata.readRetainedSlice(r);
        }
        ByteBuf dataFragment = Unpooled.EMPTY_BUFFER;
        if (remaining > 0 && data.isReadable()) {
            int r = Math.min(remaining, data.readableBytes());
            dataFragment = data.readRetainedSlice(r);
        }
        boolean follows = data.isReadable() || metadata.isReadable();
        return PayloadFrameCodec.encode(allocator, streamId, follows, false, true, metadataFragment, dataFragment);
    }

    static ByteBuf getMetadata(ByteBuf frame, FrameType frameType) {
        boolean hasMetadata = FrameHeaderCodec.hasMetadata(frame);
        if (hasMetadata) {
            ByteBuf metadata;
            switch (frameType) {
                case REQUEST_FNF: {
                    metadata = RequestFireAndForgetFrameCodec.metadata(frame);
                    break;
                }
                case REQUEST_STREAM: {
                    metadata = RequestStreamFrameCodec.metadata(frame);
                    break;
                }
                case REQUEST_RESPONSE: {
                    metadata = RequestResponseFrameCodec.metadata(frame);
                    break;
                }
                case REQUEST_CHANNEL: {
                    metadata = RequestChannelFrameCodec.metadata(frame);
                    break;
                }
                case PAYLOAD: 
                case NEXT: 
                case NEXT_COMPLETE: 
                case COMPLETE: {
                    metadata = PayloadFrameCodec.metadata(frame);
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported fragment type");
                }
            }
            return metadata;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    static ByteBuf getData(ByteBuf frame, FrameType frameType) {
        ByteBuf data;
        switch (frameType) {
            case REQUEST_FNF: {
                data = RequestFireAndForgetFrameCodec.data(frame);
                break;
            }
            case REQUEST_STREAM: {
                data = RequestStreamFrameCodec.data(frame);
                break;
            }
            case REQUEST_RESPONSE: {
                data = RequestResponseFrameCodec.data(frame);
                break;
            }
            case REQUEST_CHANNEL: {
                data = RequestChannelFrameCodec.data(frame);
                break;
            }
            case PAYLOAD: 
            case NEXT: 
            case NEXT_COMPLETE: 
            case COMPLETE: {
                data = PayloadFrameCodec.data(frame);
                break;
            }
            default: {
                throw new IllegalStateException("unsupported fragment type");
            }
        }
        return data;
    }
}

