/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.Payload;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.SendUtils;
import io.rsocket.core.StateUtils;
import io.rsocket.frame.FrameType;
import io.rsocket.internal.UnboundedProcessor;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;

final class FireAndForgetRequesterMono
extends Mono<Void>
implements Subscription,
Scannable {
    volatile long state;
    static final AtomicLongFieldUpdater<FireAndForgetRequesterMono> STATE = AtomicLongFieldUpdater.newUpdater(FireAndForgetRequesterMono.class, "state");
    final Payload payload;
    final ByteBufAllocator allocator;
    final int mtu;
    final int maxFrameLength;
    final RequesterResponderSupport requesterResponderSupport;
    final UnboundedProcessor<ByteBuf> sendProcessor;

    FireAndForgetRequesterMono(Payload payload, RequesterResponderSupport requesterResponderSupport) {
        this.allocator = requesterResponderSupport.getAllocator();
        this.payload = payload;
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.requesterResponderSupport = requesterResponderSupport;
        this.sendProcessor = requesterResponderSupport.getSendProcessor();
    }

    public void subscribe(CoreSubscriber<? super Void> actual) {
        int streamId;
        long previousState = StateUtils.markSubscribed(STATE, this);
        if (StateUtils.isSubscribedOrTerminated(previousState)) {
            Operators.error(actual, (Throwable)new IllegalStateException("FireAndForgetMono allows only a single Subscriber"));
            return;
        }
        actual.onSubscribe((Subscription)this);
        Payload p = this.payload;
        int mtu = this.mtu;
        try {
            if (!PayloadValidationUtils.isValid(mtu, this.maxFrameLength, p, false)) {
                StateUtils.lazyTerminate(STATE, this);
                p.release();
                actual.onError((Throwable)new IllegalArgumentException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength)));
                return;
            }
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            actual.onError((Throwable)e);
            return;
        }
        try {
            streamId = this.requesterResponderSupport.getNextStreamId();
        }
        catch (Throwable t) {
            StateUtils.lazyTerminate(STATE, this);
            p.release();
            actual.onError(Exceptions.unwrap((Throwable)t));
            return;
        }
        try {
            if (StateUtils.isTerminated(this.state)) {
                p.release();
                return;
            }
            SendUtils.sendReleasingPayload(streamId, FrameType.REQUEST_FNF, mtu, p, this.sendProcessor, this.allocator, true);
        }
        catch (Throwable e) {
            StateUtils.lazyTerminate(STATE, this);
            actual.onError(e);
            return;
        }
        StateUtils.lazyTerminate(STATE, this);
        actual.onComplete();
    }

    public void request(long n) {
    }

    public void cancel() {
        StateUtils.markTerminated(STATE, this);
    }

    @Nullable
    public Void block(Duration m) {
        return this.block();
    }

    @Nullable
    public Void block() {
        int streamId;
        long previousState = StateUtils.markSubscribed(STATE, this);
        if (StateUtils.isSubscribedOrTerminated(previousState)) {
            throw new IllegalStateException("FireAndForgetMono allows only a single Subscriber");
        }
        Payload p = this.payload;
        try {
            if (!PayloadValidationUtils.isValid(this.mtu, this.maxFrameLength, p, false)) {
                StateUtils.lazyTerminate(STATE, this);
                p.release();
                throw new IllegalArgumentException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength));
            }
        }
        catch (IllegalReferenceCountException e) {
            StateUtils.lazyTerminate(STATE, this);
            throw Exceptions.propagate((Throwable)e);
        }
        try {
            streamId = this.requesterResponderSupport.getNextStreamId();
        }
        catch (Throwable t) {
            StateUtils.lazyTerminate(STATE, this);
            p.release();
            throw Exceptions.propagate((Throwable)t);
        }
        try {
            SendUtils.sendReleasingPayload(streamId, FrameType.REQUEST_FNF, this.mtu, this.payload, this.sendProcessor, this.allocator, true);
        }
        catch (Throwable e) {
            StateUtils.lazyTerminate(STATE, this);
            throw Exceptions.propagate((Throwable)e);
        }
        StateUtils.lazyTerminate(STATE, this);
        return null;
    }

    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }

    @NonNull
    public String stepName() {
        return "source(FireAndForgetMono)";
    }
}

