/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.ReassemblyUtils;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.ResponderFrameHandler;
import io.rsocket.core.SendUtils;
import io.rsocket.exceptions.CanceledException;
import io.rsocket.frame.ErrorFrameCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.UnboundedProcessor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class RequestResponseResponderSubscriber
implements ResponderFrameHandler,
CoreSubscriber<Payload> {
    static final Logger logger = LoggerFactory.getLogger(RequestResponseResponderSubscriber.class);
    final int streamId;
    final ByteBufAllocator allocator;
    final PayloadDecoder payloadDecoder;
    final int mtu;
    final int maxFrameLength;
    final int maxInboundPayloadSize;
    final RequesterResponderSupport requesterResponderSupport;
    final UnboundedProcessor<ByteBuf> sendProcessor;
    final RSocket handler;
    CompositeByteBuf frames;
    volatile Subscription s;
    static final AtomicReferenceFieldUpdater<RequestResponseResponderSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(RequestResponseResponderSubscriber.class, Subscription.class, "s");

    public RequestResponseResponderSubscriber(int streamId, ByteBuf firstFrame, RequesterResponderSupport requesterResponderSupport, RSocket handler) {
        this.streamId = streamId;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.sendProcessor = requesterResponderSupport.getSendProcessor();
        this.payloadDecoder = requesterResponderSupport.getPayloadDecoder();
        this.handler = handler;
        this.frames = ReassemblyUtils.addFollowingFrame(this.allocator.compositeBuffer(), firstFrame, true, this.maxInboundPayloadSize);
    }

    public RequestResponseResponderSubscriber(int streamId, RequesterResponderSupport requesterResponderSupport) {
        this.streamId = streamId;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.sendProcessor = requesterResponderSupport.getSendProcessor();
        this.payloadDecoder = null;
        this.handler = null;
        this.frames = null;
    }

    public void onSubscribe(Subscription subscription) {
        if (Operators.validate((Subscription)this.s, (Subscription)subscription)) {
            S.lazySet(this, subscription);
            subscription.request(Long.MAX_VALUE);
        }
    }

    public void onNext(@Nullable Payload p) {
        if (!Operators.terminate(S, (Object)this)) {
            if (p != null) {
                p.release();
            }
            return;
        }
        int streamId = this.streamId;
        UnboundedProcessor<ByteBuf> sender = this.sendProcessor;
        ByteBufAllocator allocator = this.allocator;
        this.requesterResponderSupport.remove(streamId, this);
        if (p == null) {
            ByteBuf completeFrame = PayloadFrameCodec.encodeComplete(allocator, streamId);
            sender.onNext(completeFrame);
            return;
        }
        int mtu = this.mtu;
        try {
            if (!PayloadValidationUtils.isValid(mtu, this.maxFrameLength, p, false)) {
                p.release();
                ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, new CanceledException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength)));
                sender.onNext(errorFrame);
                return;
            }
        }
        catch (IllegalReferenceCountException e) {
            ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, new CanceledException("Failed to validate payload. Cause" + e.getMessage()));
            sender.onNext(errorFrame);
            return;
        }
        try {
            SendUtils.sendReleasingPayload(streamId, FrameType.NEXT_COMPLETE, mtu, p, sender, allocator, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onError(Throwable t) {
        if (S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            logger.debug("Dropped error", t);
            return;
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, t);
        this.sendProcessor.onNext(errorFrame);
    }

    public void onComplete() {
        this.onNext(null);
    }

    @Override
    public void handleCancel() {
        Subscription currentSubscription = this.s;
        if (currentSubscription == Operators.cancelledSubscription()) {
            return;
        }
        if (currentSubscription == null) {
            S.lazySet(this, Operators.cancelledSubscription());
            this.requesterResponderSupport.remove(this.streamId, this);
            CompositeByteBuf frames = this.frames;
            if (frames != null) {
                this.frames = null;
                frames.release();
            }
            return;
        }
        if (!S.compareAndSet(this, currentSubscription, Operators.cancelledSubscription())) {
            return;
        }
        this.requesterResponderSupport.remove(this.streamId, this);
        currentSubscription.cancel();
    }

    @Override
    public void handleNext(ByteBuf frame, boolean hasFollows, boolean isLastPayload) {
        CompositeByteBuf frames = this.frames;
        if (frames == null) {
            return;
        }
        try {
            ReassemblyUtils.addFollowingFrame(frames, frame, hasFollows, this.maxInboundPayloadSize);
        }
        catch (IllegalStateException t) {
            S.lazySet(this, Operators.cancelledSubscription());
            this.requesterResponderSupport.remove(this.streamId, this);
            this.frames = null;
            frames.release();
            logger.debug("Reassembly has failed", (Throwable)t);
            ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, this.streamId, new CanceledException("Failed to reassemble payload. Cause: " + t.getMessage()));
            this.sendProcessor.onNext(errorFrame);
            return;
        }
        if (!hasFollows) {
            Payload payload;
            this.frames = null;
            try {
                payload = (Payload)this.payloadDecoder.apply(frames);
                frames.release();
            }
            catch (Throwable t) {
                S.lazySet(this, Operators.cancelledSubscription());
                this.requesterResponderSupport.remove(this.streamId, this);
                ReferenceCountUtil.safeRelease((Object)frames);
                logger.debug("Reassembly has failed", t);
                ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, this.streamId, new CanceledException("Failed to reassemble payload. Cause: " + t.getMessage()));
                this.sendProcessor.onNext(errorFrame);
                return;
            }
            Mono<Payload> source = this.handler.requestResponse(payload);
            source.subscribe((CoreSubscriber)this);
        }
    }

    public Context currentContext() {
        return SendUtils.DISCARD_CONTEXT;
    }
}

