/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

class ResolvingOperator<T>
implements Disposable {
    static final CancellationException ON_DISPOSE = new CancellationException("Disposed");
    volatile int wip;
    static final AtomicIntegerFieldUpdater<ResolvingOperator> WIP = AtomicIntegerFieldUpdater.newUpdater(ResolvingOperator.class, "wip");
    volatile BiConsumer<T, Throwable>[] subscribers;
    static final AtomicReferenceFieldUpdater<ResolvingOperator, BiConsumer[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(ResolvingOperator.class, BiConsumer[].class, "subscribers");
    static final BiConsumer<?, Throwable>[] EMPTY_UNSUBSCRIBED = new BiConsumer[0];
    static final BiConsumer<?, Throwable>[] EMPTY_SUBSCRIBED = new BiConsumer[0];
    static final BiConsumer<?, Throwable>[] READY = new BiConsumer[0];
    static final BiConsumer<?, Throwable>[] TERMINATED = new BiConsumer[0];
    static final int ADDED_STATE = 0;
    static final int READY_STATE = 1;
    static final int TERMINATED_STATE = 2;
    T value;
    Throwable t;

    public ResolvingOperator() {
        SUBSCRIBERS.lazySet(this, EMPTY_UNSUBSCRIBED);
    }

    public final void dispose() {
        this.terminate(ON_DISPOSE);
    }

    public final boolean isDisposed() {
        return this.subscribers == TERMINATED;
    }

    public final boolean isPending() {
        BiConsumer<T, Throwable>[] state = this.subscribers;
        return state != READY && state != TERMINATED;
    }

    @Nullable
    public final T valueIfResolved() {
        T value;
        if (this.subscribers == READY && (value = this.value) != null) {
            return value;
        }
        return null;
    }

    final void observe(BiConsumer<T, Throwable> actual) {
        int state;
        block2: {
            T value;
            do {
                state = this.add(actual);
                value = this.value;
                if (state != 1) break block2;
            } while (value == null);
            actual.accept(value, null);
            return;
        }
        if (state == 2) {
            actual.accept(null, this.t);
            return;
        }
    }

    @Nullable
    public T block(@Nullable Duration timeout) {
        try {
            BiConsumer<T, Throwable>[] subscribers = this.subscribers;
            if (subscribers == READY) {
                T value = this.value;
                if (value != null) {
                    return value;
                }
                subscribers = this.subscribers;
            }
            if (subscribers == TERMINATED) {
                RuntimeException re = Exceptions.propagate((Throwable)this.t);
                re = Exceptions.addSuppressed((RuntimeException)re, (Throwable)new Exception("Terminated with an error"));
                throw re;
            }
            if (subscribers == EMPTY_UNSUBSCRIBED && SUBSCRIBERS.compareAndSet(this, EMPTY_UNSUBSCRIBED, EMPTY_SUBSCRIBED)) {
                this.doSubscribe();
            }
            long delay = null == timeout ? 0L : System.nanoTime() + timeout.toNanos();
            while (true) {
                if ((subscribers = this.subscribers) == READY) {
                    T value = this.value;
                    if (value != null) {
                        return value;
                    }
                    subscribers = this.subscribers;
                }
                if (subscribers == TERMINATED) {
                    RuntimeException re = Exceptions.propagate((Throwable)this.t);
                    re = Exceptions.addSuppressed((RuntimeException)re, (Throwable)new Exception("Terminated with an error"));
                    throw re;
                }
                if (timeout != null && delay < System.nanoTime()) {
                    throw new IllegalStateException("Timeout on Mono blocking read");
                }
                if (subscribers == EMPTY_UNSUBSCRIBED && SUBSCRIBERS.compareAndSet(this, EMPTY_UNSUBSCRIBED, EMPTY_SUBSCRIBED)) {
                    this.doSubscribe();
                }
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread Interruption on Mono blocking read");
        }
    }

    final void terminate(Throwable t) {
        if (this.isDisposed()) {
            Operators.onErrorDropped((Throwable)t, (Context)Context.empty());
            return;
        }
        this.t = t;
        BiConsumer<?, Throwable>[] subscribers = SUBSCRIBERS.getAndSet(this, TERMINATED);
        if (subscribers == TERMINATED) {
            Operators.onErrorDropped((Throwable)t, (Context)Context.empty());
            return;
        }
        this.doOnDispose();
        this.doFinally();
        for (BiConsumer<?, Throwable> consumer : subscribers) {
            consumer.accept(null, t);
        }
    }

    final void complete(T value) {
        BiConsumer<T, Throwable>[] subscribers = this.subscribers;
        if (subscribers == TERMINATED) {
            this.doOnValueExpired(value);
            return;
        }
        this.value = value;
        while (!SUBSCRIBERS.compareAndSet(this, subscribers, READY)) {
            subscribers = this.subscribers;
            if (subscribers != TERMINATED) continue;
            this.doFinally();
            return;
        }
        this.doOnValueResolved(value);
        for (BiConsumer<T, Throwable> consumer : subscribers) {
            consumer.accept(value, null);
        }
    }

    protected void doOnValueResolved(T value) {
    }

    final void doFinally() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int m = 1;
        do {
            T value;
            if ((value = this.value) == null || !this.isDisposed()) continue;
            this.value = null;
            this.doOnValueExpired(value);
            return;
        } while ((m = WIP.addAndGet(this, -m)) != 0);
    }

    final void invalidate() {
        if (this.subscribers == TERMINATED) {
            return;
        }
        BiConsumer<T, Throwable>[] subscribers = this.subscribers;
        if (subscribers == READY) {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            T value = this.value;
            if (value != null) {
                this.value = null;
                this.doOnValueExpired(value);
            }
            int m = 1;
            do {
                if (!this.isDisposed()) continue;
                return;
            } while ((m = WIP.addAndGet(this, -m)) != 0);
            SUBSCRIBERS.compareAndSet(this, READY, EMPTY_UNSUBSCRIBED);
        }
    }

    protected void doOnValueExpired(T value) {
    }

    protected void doOnDispose() {
    }

    final int add(BiConsumer<T, Throwable> ps) {
        BiConsumer[] b;
        BiConsumer<T, Throwable>[] a;
        do {
            if ((a = this.subscribers) == TERMINATED) {
                return 2;
            }
            if (a == READY) {
                return 1;
            }
            int n = a.length;
            b = new BiConsumer[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        if (a == EMPTY_UNSUBSCRIBED) {
            this.doSubscribe();
        }
        return 0;
    }

    protected void doSubscribe() {
    }

    final void remove(BiConsumer<T, Throwable> ps) {
        BiConsumer<?, Throwable>[] b;
        BiConsumer<T, Throwable>[] a;
        do {
            int n;
            if ((n = (a = this.subscribers).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY_SUBSCRIBED;
                continue;
            }
            b = new BiConsumer[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
    }
}

