/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.Payload;
import io.rsocket.core.RequesterFrameHandler;
import io.rsocket.core.StateUtils;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.decoder.PayloadDecoder;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;

class ReassemblyUtils {
    static final String ILLEGAL_REASSEMBLED_PAYLOAD_SIZE = "Reassembled payload size went out of allowed %s bytes";

    ReassemblyUtils() {
    }

    static void release(RequesterFrameHandler framesHolder, long state) {
        if (StateUtils.isReassembling(state)) {
            CompositeByteBuf frames = framesHolder.getFrames();
            framesHolder.setFrames(null);
            frames.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void synchronizedRelease(RequesterFrameHandler framesHolder, long state) {
        if (StateUtils.isReassembling(state)) {
            CompositeByteBuf frames = framesHolder.getFrames();
            framesHolder.setFrames(null);
            CompositeByteBuf compositeByteBuf = frames;
            synchronized (compositeByteBuf) {
                frames.release();
            }
        }
    }

    static <T extends RequesterFrameHandler> void handleNextSupport(AtomicLongFieldUpdater<T> updater, T instance, Subscription subscription, CoreSubscriber<? super Payload> inboundSubscriber, PayloadDecoder payloadDecoder, ByteBufAllocator allocator, int maxInboundPayloadSize, ByteBuf frame, boolean hasFollows, boolean isLastPayload) {
        long previousState;
        long state = updater.get(instance);
        if (StateUtils.isTerminated(state)) {
            return;
        }
        if (!hasFollows && !StateUtils.isReassembling(state)) {
            Payload payload;
            try {
                payload = (Payload)payloadDecoder.apply(frame);
            }
            catch (Throwable t) {
                subscription.cancel();
                inboundSubscriber.onError(t);
                return;
            }
            instance.handlePayload(payload);
            if (isLastPayload) {
                instance.handleComplete();
            }
            return;
        }
        CompositeByteBuf frames = instance.getFrames();
        if (frames == null) {
            frames = ReassemblyUtils.addFollowingFrame(allocator.compositeBuffer(), frame, hasFollows, maxInboundPayloadSize);
            instance.setFrames(frames);
            previousState = StateUtils.markReassembling(updater, instance);
            if (StateUtils.isTerminated(previousState)) {
                instance.setFrames(null);
                frames.release();
                return;
            }
        } else {
            try {
                frames = ReassemblyUtils.addFollowingFrame(frames, frame, hasFollows, maxInboundPayloadSize);
            }
            catch (IllegalStateException t) {
                if (StateUtils.isTerminated(updater.get(instance))) {
                    return;
                }
                subscription.cancel();
                inboundSubscriber.onError((Throwable)t);
                return;
            }
        }
        if (!hasFollows) {
            Payload payload;
            previousState = StateUtils.markReassembled(updater, instance);
            if (StateUtils.isTerminated(previousState)) {
                return;
            }
            instance.setFrames(null);
            try {
                payload = (Payload)payloadDecoder.apply(frames);
                frames.release();
            }
            catch (Throwable t) {
                ReferenceCountUtil.safeRelease((Object)frames);
                subscription.cancel();
                inboundSubscriber.onError(t);
                return;
            }
            instance.handlePayload(payload);
            if (isLastPayload) {
                instance.handleComplete();
            }
        }
    }

    static CompositeByteBuf addFollowingFrame(CompositeByteBuf frames, ByteBuf followingFrame, boolean hasFollows, int maxInboundPayloadSize) {
        int readableBytes = frames.readableBytes();
        if (readableBytes == 0) {
            return frames.addComponent(true, followingFrame.retain());
        }
        if (maxInboundPayloadSize != Integer.MAX_VALUE && readableBytes + followingFrame.readableBytes() - FrameHeaderCodec.size() > maxInboundPayloadSize) {
            throw new IllegalStateException(String.format(ILLEGAL_REASSEMBLED_PAYLOAD_SIZE, maxInboundPayloadSize));
        }
        if (followingFrame.readableBytes() < 61 && hasFollows) {
            throw new IllegalStateException("Fragment is too small.");
        }
        boolean hasMetadata = FrameHeaderCodec.hasMetadata(followingFrame);
        followingFrame.skipBytes(FrameHeaderCodec.size());
        if (hasMetadata) {
            FrameType frameType = FrameHeaderCodec.frameType((ByteBuf)frames);
            int lengthFieldPosition = FrameHeaderCodec.size() + (frameType.hasInitialRequestN() ? 4 : 0);
            frames.markReaderIndex();
            frames.skipBytes(lengthFieldPosition);
            int nextMetadataLength = ReassemblyUtils.decodeLength((ByteBuf)frames) + ReassemblyUtils.decodeLength(followingFrame);
            frames.resetReaderIndex();
            frames.markWriterIndex();
            frames.writerIndex(lengthFieldPosition);
            ReassemblyUtils.encodeLength((ByteBuf)frames, nextMetadataLength);
            frames.resetWriterIndex();
        }
        CompositeByteBuf compositeByteBuf = frames;
        synchronized (compositeByteBuf) {
            if (frames.refCnt() > 0) {
                followingFrame.retain();
                return frames.addComponent(true, followingFrame);
            }
            throw new IllegalReferenceCountException(0);
        }
    }

    private static void encodeLength(ByteBuf byteBuf, int length) {
        if ((length & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Length is larger than 24 bits");
        }
        byteBuf.writeByte(length >> 16);
        byteBuf.writeByte(length >> 8);
        byteBuf.writeByte(length);
    }

    private static int decodeLength(ByteBuf byteBuf) {
        int length = (byteBuf.readByte() & 0xFF) << 16;
        length |= (byteBuf.readByte() & 0xFF) << 8;
        return length |= byteBuf.readByte() & 0xFF;
    }

    static int assertInboundPayloadSize(int inboundPayloadSize) {
        if (inboundPayloadSize < 64) {
            String msg = String.format("The min allowed inboundPayloadSize size is %d bytes, provided: %d", 0xFFFFFF, inboundPayloadSize);
            throw new IllegalArgumentException(msg);
        }
        return inboundPayloadSize;
    }
}

