/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.time.Duration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;

class LeaksTrackingByteBufAllocator
implements ByteBufAllocator {
    final ConcurrentLinkedQueue<ByteBuf> tracker = new ConcurrentLinkedQueue();
    final ByteBufAllocator delegate;
    final Duration awaitZeroRefCntDuration;

    public static LeaksTrackingByteBufAllocator instrument(ByteBufAllocator allocator) {
        return new LeaksTrackingByteBufAllocator(allocator, Duration.ZERO);
    }

    public static LeaksTrackingByteBufAllocator instrument(ByteBufAllocator allocator, Duration awaitZeroRefCntDuration) {
        return new LeaksTrackingByteBufAllocator(allocator, awaitZeroRefCntDuration);
    }

    private LeaksTrackingByteBufAllocator(ByteBufAllocator delegate, Duration awaitZeroRefCntDuration) {
        this.delegate = delegate;
        this.awaitZeroRefCntDuration = awaitZeroRefCntDuration;
    }

    public LeaksTrackingByteBufAllocator assertHasNoLeaks() {
        try {
            Assertions.assertThat(this.tracker).allSatisfy(buf -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)buf).matches(bb -> {
                    Duration awaitZeroRefCntDuration = this.awaitZeroRefCntDuration;
                    if (!awaitZeroRefCntDuration.isZero()) {
                        long end = awaitZeroRefCntDuration.plusNanos(System.nanoTime()).toNanos();
                        while (bb.refCnt() != 0 && System.nanoTime() < end) {
                            LockSupport.parkNanos(100L);
                        }
                    }
                    return bb.refCnt() == 0;
                }, "buffer should be released");
            });
        }
        finally {
            this.tracker.clear();
        }
        return this;
    }

    public ByteBuf buffer() {
        return this.track(this.delegate.buffer());
    }

    public ByteBuf buffer(int initialCapacity) {
        return this.track(this.delegate.buffer(initialCapacity));
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.track(this.delegate.buffer(initialCapacity, maxCapacity));
    }

    public ByteBuf ioBuffer() {
        return this.track(this.delegate.ioBuffer());
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return this.track(this.delegate.ioBuffer(initialCapacity));
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.track(this.delegate.ioBuffer(initialCapacity, maxCapacity));
    }

    public ByteBuf heapBuffer() {
        return this.track(this.delegate.heapBuffer());
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        return this.track(this.delegate.heapBuffer(initialCapacity));
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        return this.track(this.delegate.heapBuffer(initialCapacity, maxCapacity));
    }

    public ByteBuf directBuffer() {
        return this.track(this.delegate.directBuffer());
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return this.track(this.delegate.directBuffer(initialCapacity));
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.track(this.delegate.directBuffer(initialCapacity, maxCapacity));
    }

    public CompositeByteBuf compositeBuffer() {
        return this.track(this.delegate.compositeBuffer());
    }

    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return this.track(this.delegate.compositeBuffer(maxNumComponents));
    }

    public CompositeByteBuf compositeHeapBuffer() {
        return this.track(this.delegate.compositeHeapBuffer());
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return this.track(this.delegate.compositeHeapBuffer(maxNumComponents));
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return this.track(this.delegate.compositeDirectBuffer());
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.track(this.delegate.compositeDirectBuffer(maxNumComponents));
    }

    public boolean isDirectBufferPooled() {
        return this.delegate.isDirectBufferPooled();
    }

    public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
        return this.delegate.calculateNewCapacity(minNewCapacity, maxCapacity);
    }

    <T extends ByteBuf> T track(T buffer) {
        this.tracker.offer(buffer);
        return buffer;
    }
}

