/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.fragmentation.ReassemblyDuplexConnection;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.local.LocalDuplexConnection;
import io.rsocket.transport.local.LocalServerTransport;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public final class LocalClientTransport
implements ClientTransport {
    private final String name;
    private final ByteBufAllocator allocator;

    private LocalClientTransport(String name, ByteBufAllocator allocator) {
        this.name = name;
        this.allocator = allocator;
    }

    public static LocalClientTransport create(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return LocalClientTransport.create(name, ByteBufAllocator.DEFAULT);
    }

    public static LocalClientTransport create(String name, ByteBufAllocator allocator) {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(allocator, "allocator must not be null");
        return new LocalClientTransport(name, allocator);
    }

    private Mono<DuplexConnection> connect() {
        return Mono.defer(() -> {
            LocalServerTransport.ServerDuplexConnectionAcceptor server = LocalServerTransport.findServer(this.name);
            if (server == null) {
                return Mono.error((Throwable)new IllegalArgumentException("Could not find server: " + this.name));
            }
            UnboundedProcessor in = new UnboundedProcessor();
            UnboundedProcessor out = new UnboundedProcessor();
            MonoProcessor closeNotifier = MonoProcessor.create();
            server.accept(new LocalDuplexConnection(this.allocator, (Flux<ByteBuf>)out, (Subscriber<ByteBuf>)in, (MonoProcessor<Void>)closeNotifier));
            return Mono.just((Object)new LocalDuplexConnection(this.allocator, (Flux<ByteBuf>)in, (Subscriber<ByteBuf>)out, (MonoProcessor<Void>)closeNotifier));
        });
    }

    public Mono<DuplexConnection> connect(int mtu) {
        Mono<DuplexConnection> isError = FragmentationDuplexConnection.checkMtu((int)mtu);
        Mono<DuplexConnection> connect = isError != null ? isError : this.connect();
        return connect.map(duplexConnection -> {
            if (mtu > 0) {
                return new FragmentationDuplexConnection(duplexConnection, mtu, false, "client");
            }
            return new ReassemblyDuplexConnection(duplexConnection, false);
        });
    }
}

