/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.DuplexConnection;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.local.LocalDuplexConnection;
import io.rsocket.transport.local.LocalServerTransport;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public final class LocalClientTransport
implements ClientTransport {
    private final String name;
    private final ByteBufAllocator allocator;

    private LocalClientTransport(String name, ByteBufAllocator allocator) {
        this.name = name;
        this.allocator = allocator;
    }

    public static LocalClientTransport create(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return LocalClientTransport.create(name, ByteBufAllocator.DEFAULT);
    }

    public static LocalClientTransport create(String name, ByteBufAllocator allocator) {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(allocator, "allocator must not be null");
        return new LocalClientTransport(name, allocator);
    }

    public Mono<DuplexConnection> connect() {
        return Mono.defer(() -> {
            ServerTransport.ConnectionAcceptor server = LocalServerTransport.findServer(this.name);
            if (server == null) {
                return Mono.error((Throwable)new IllegalArgumentException("Could not find server: " + this.name));
            }
            UnboundedProcessor in = new UnboundedProcessor();
            UnboundedProcessor out = new UnboundedProcessor();
            MonoProcessor closeNotifier = MonoProcessor.create();
            server.apply((DuplexConnection)new LocalDuplexConnection(this.name, this.allocator, (Flux<ByteBuf>)out, in, (MonoProcessor<Void>)closeNotifier)).subscribe();
            return Mono.just((Object)new LocalDuplexConnection(this.name, this.allocator, (Flux<ByteBuf>)in, out, (MonoProcessor<Void>)closeNotifier));
        });
    }
}

