/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.client;

import io.netty.channel.ChannelHandler;
import io.rsocket.DuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.NettyDuplexConnection;
import io.rsocket.transport.netty.RSocketLengthCodec;
import java.net.InetSocketAddress;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.tcp.TcpClient;

public class TcpClientTransport
implements ClientTransport {
    private final TcpClient client;

    private TcpClientTransport(TcpClient client) {
        this.client = client;
    }

    public static TcpClientTransport create(int port) {
        TcpClient tcpClient = TcpClient.create((int)port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(String bindAddress, int port) {
        TcpClient tcpClient = TcpClient.create((String)bindAddress, (int)port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(InetSocketAddress address) {
        TcpClient tcpClient = TcpClient.create((String)address.getHostString(), (int)address.getPort());
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(TcpClient client) {
        return new TcpClientTransport(client);
    }

    public Mono<DuplexConnection> connect() {
        return Mono.create((T sink) -> this.client.newHandler((in, out) -> {
            in.context().addHandler("client-length-codec", (ChannelHandler)new RSocketLengthCodec());
            NettyDuplexConnection connection = new NettyDuplexConnection((NettyInbound)in, (NettyOutbound)out, in.context());
            sink.success((Object)connection);
            return connection.onClose();
        }).doOnError(arg_0 -> ((MonoSink)sink).error(arg_0)).subscribe());
    }
}

