/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.rsocket.Frame;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.Queues;

class SendPublisher<V extends ReferenceCounted>
extends Flux<Frame> {
    private static final AtomicIntegerFieldUpdater<SendPublisher> WIP = AtomicIntegerFieldUpdater.newUpdater(SendPublisher.class, "wip");
    private static final int MAX_SIZE = Queues.SMALL_BUFFER_SIZE;
    private static final int REFILL_SIZE = MAX_SIZE / 2;
    private static final AtomicReferenceFieldUpdater<SendPublisher, Object> INNER_SUBSCRIBER = AtomicReferenceFieldUpdater.newUpdater(SendPublisher.class, Object.class, "innerSubscriber");
    private static final AtomicIntegerFieldUpdater<SendPublisher> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(SendPublisher.class, "terminated");
    private final Publisher<Frame> source;
    private final Channel channel;
    private final EventLoop eventLoop;
    private final Queue<Frame> queue;
    private final AtomicBoolean completed = new AtomicBoolean();
    private final Function<Frame, V> transformer;
    private final SizeOf<V> sizeOf;
    private volatile int terminated;
    private int pending;
    private volatile int wip;
    private volatile Object innerSubscriber;
    private long requested;
    private long requestedUpstream = MAX_SIZE;
    private boolean fuse;

    SendPublisher(Publisher<Frame> source, Channel channel, Function<Frame, V> transformer, SizeOf<V> sizeOf) {
        this((Queue)Queues.small().get(), source, channel, transformer, sizeOf);
    }

    SendPublisher(Queue<Frame> queue, Publisher<Frame> source, Channel channel, Function<Frame, V> transformer, SizeOf<V> sizeOf) {
        this.source = source;
        this.channel = channel;
        this.queue = queue;
        this.eventLoop = channel.eventLoop();
        this.transformer = transformer;
        this.sizeOf = sizeOf;
        this.fuse = queue instanceof Fuseable.QueueSubscription;
    }

    private ChannelPromise writeCleanupPromise(V poll) {
        return this.channel.newPromise().addListener(future -> {
            try {
                if (this.requested != Long.MAX_VALUE) {
                    --this.requested;
                }
                --this.requestedUpstream;
                --this.pending;
                InnerSubscriber is = (InnerSubscriber)INNER_SUBSCRIBER.get(this);
                if (is != null) {
                    is.tryRequestMoreUpstream();
                    this.tryComplete(is);
                }
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)poll);
            }
        });
    }

    private void tryComplete(InnerSubscriber is) {
        if (this.pending == 0 && this.completed.get() && this.queue.isEmpty() && this.terminated == 0 && !is.pendingFlush.get()) {
            TERMINATED.set(this, 1);
            is.destination.onComplete();
        }
    }

    public void subscribe(CoreSubscriber<? super Frame> destination) {
        InnerSubscriber innerSubscriber = new InnerSubscriber(destination);
        if (!INNER_SUBSCRIBER.compareAndSet(this, null, innerSubscriber)) {
            Operators.error(destination, (Throwable)new IllegalStateException("SendPublisher only allows one subscription"));
        } else {
            InnerSubscription innerSubscription = new InnerSubscription(innerSubscriber);
            destination.onSubscribe((Subscription)innerSubscription);
            this.source.subscribe((Subscriber)innerSubscriber);
        }
    }

    private class InnerSubscription
    implements Subscription {
        private final InnerSubscriber innerSubscriber;

        private InnerSubscription(InnerSubscriber innerSubscriber) {
            this.innerSubscriber = innerSubscriber;
        }

        public void request(long n) {
            if (SendPublisher.this.eventLoop.inEventLoop()) {
                SendPublisher.this.requested = Operators.addCap((long)n, (long)SendPublisher.this.requested);
                this.innerSubscriber.tryDrain();
            } else {
                SendPublisher.this.eventLoop.execute(() -> this.request(n));
            }
        }

        public void cancel() {
            TERMINATED.set(SendPublisher.this, 1);
            while (!SendPublisher.this.queue.isEmpty()) {
                Frame poll = (Frame)SendPublisher.this.queue.poll();
                if (poll == null) continue;
                ReferenceCountUtil.safeRelease((Object)poll);
            }
        }
    }

    private class InnerSubscriber
    implements Subscriber<Frame> {
        final CoreSubscriber<? super Frame> destination;
        volatile Subscription s;
        private AtomicBoolean pendingFlush = new AtomicBoolean();

        private InnerSubscriber(CoreSubscriber<? super Frame> destination) {
            this.destination = destination;
        }

        public void onSubscribe(Subscription s) {
            this.s = s;
            s.request((long)MAX_SIZE);
            this.tryDrain();
        }

        public void onNext(Frame t) {
            if (SendPublisher.this.terminated == 0) {
                if (!SendPublisher.this.fuse && !SendPublisher.this.queue.offer(t)) {
                    throw new IllegalStateException("missing back pressure");
                }
                this.tryDrain();
            }
        }

        public void onError(Throwable t) {
            if (TERMINATED.compareAndSet(SendPublisher.this, 0, 1)) {
                try {
                    this.s.cancel();
                    this.destination.onError(t);
                }
                finally {
                    if (!SendPublisher.this.queue.isEmpty()) {
                        SendPublisher.this.queue.forEach(ReferenceCountUtil::safeRelease);
                    }
                }
            }
        }

        public void onComplete() {
            if (SendPublisher.this.completed.compareAndSet(false, true)) {
                this.tryDrain();
            }
        }

        private void tryRequestMoreUpstream() {
            if (SendPublisher.this.requestedUpstream <= (long)REFILL_SIZE && this.s != null) {
                long u = (long)MAX_SIZE - SendPublisher.this.requestedUpstream;
                SendPublisher.this.requestedUpstream = Operators.addCap((long)SendPublisher.this.requestedUpstream, (long)u);
                this.s.request(u);
            }
        }

        private void flush() {
            try {
                SendPublisher.this.channel.flush();
                this.pendingFlush.set(false);
                SendPublisher.this.tryComplete(this);
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }

        private void tryDrain() {
            if (SendPublisher.this.wip == 0 && SendPublisher.this.terminated == 0 && WIP.getAndIncrement(SendPublisher.this) == 0) {
                try {
                    if (SendPublisher.this.eventLoop.inEventLoop()) {
                        this.drain();
                    } else {
                        SendPublisher.this.eventLoop.execute(this::drain);
                    }
                }
                catch (Throwable t) {
                    this.onError(t);
                }
            }
        }

        private void drain() {
            try {
                int missed = 1;
                do {
                    Frame frame;
                    boolean scheduleFlush = false;
                    long r = Math.min(SendPublisher.this.requested, SendPublisher.this.requestedUpstream);
                    while (r-- > 0L && (frame = (Frame)SendPublisher.this.queue.poll()) != null && SendPublisher.this.terminated == 0) {
                        ReferenceCounted poll = (ReferenceCounted)SendPublisher.this.transformer.apply(frame);
                        int readableBytes = SendPublisher.this.sizeOf.size(poll);
                        SendPublisher.this.pending++;
                        if (SendPublisher.this.channel.isWritable() && (long)readableBytes <= SendPublisher.this.channel.bytesBeforeUnwritable()) {
                            SendPublisher.this.channel.write((Object)poll, SendPublisher.this.writeCleanupPromise(poll));
                            scheduleFlush = true;
                        } else {
                            scheduleFlush = false;
                            SendPublisher.this.channel.writeAndFlush((Object)poll, SendPublisher.this.writeCleanupPromise(poll));
                        }
                        this.tryRequestMoreUpstream();
                    }
                    if (!scheduleFlush) continue;
                    this.pendingFlush.set(true);
                    SendPublisher.this.eventLoop.execute(this::flush);
                } while (SendPublisher.this.terminated != 1 && (missed = WIP.addAndGet(SendPublisher.this, -missed)) != 0);
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }
    }

    @FunctionalInterface
    static interface SizeOf<V> {
        public int size(V var1);
    }
}

