/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.rsocket.Closeable;
import io.rsocket.DuplexConnection;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import io.rsocket.transport.netty.server.NettyContextCloseable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.http.server.HttpServer;
import reactor.ipc.netty.http.server.HttpServerRoutes;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

public class WebsocketRouteTransport
implements ServerTransport<Closeable> {
    private HttpServer server;
    private Consumer<? super HttpServerRoutes> routesBuilder;
    private String path;

    public WebsocketRouteTransport(HttpServer server, Consumer<? super HttpServerRoutes> routesBuilder, String path) {
        this.server = server;
        this.routesBuilder = routesBuilder;
        this.path = path;
    }

    public Mono<Closeable> start(ServerTransport.ConnectionAcceptor acceptor) {
        return this.server.newRouter(routes -> {
            this.routesBuilder.accept((HttpServerRoutes)routes);
            routes.ws(this.path, WebsocketRouteTransport.newHandler(acceptor));
        }).map(NettyContextCloseable::new);
    }

    public static BiFunction<WebsocketInbound, WebsocketOutbound, Publisher<Void>> newHandler(ServerTransport.ConnectionAcceptor acceptor) {
        return (in, out) -> {
            WebsocketDuplexConnection connection = new WebsocketDuplexConnection((NettyInbound)in, (NettyOutbound)out, in.context());
            acceptor.apply((DuplexConnection)connection).subscribe();
            return out.neverComplete();
        };
    }
}

