/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.rsocket.Frame;
import io.rsocket.internal.BaseDuplexConnection;
import io.rsocket.transport.netty.SendPublisher;
import java.util.Objects;
import java.util.Queue;
import org.reactivestreams.Publisher;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public final class TcpDuplexConnection
extends BaseDuplexConnection {
    private final Connection connection;

    public TcpDuplexConnection(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "connection must not be null");
        connection.channel().closeFuture().addListener(future -> {
            if (!this.isDisposed()) {
                this.dispose();
            }
        });
    }

    protected void doOnClose() {
        if (!this.connection.isDisposed()) {
            this.connection.dispose();
        }
    }

    public Flux<Frame> receive() {
        return this.connection.inbound().receive().map(buf -> Frame.from((ByteBuf)buf.retain()));
    }

    public Mono<Void> send(Publisher<Frame> frames) {
        return Flux.from(frames).transform(frameFlux -> {
            if (frameFlux instanceof Fuseable.QueueSubscription) {
                Fuseable.QueueSubscription queueSubscription = (Fuseable.QueueSubscription)frameFlux;
                queueSubscription.requestFusion(2);
                return new SendPublisher<ByteBuf>((Queue<Frame>)queueSubscription, (Publisher<Frame>)frameFlux, this.connection.channel(), frame -> frame.content().retain(), ByteBuf::readableBytes);
            }
            return new SendPublisher<ByteBuf>((Publisher<Frame>)frameFlux, this.connection.channel(), frame -> frame.content().retain(), ByteBuf::readableBytes);
        }).then();
    }
}

