/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import io.rsocket.frame.FrameHeaderFlyweight;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public final class WebsocketDuplexConnection
implements DuplexConnection {
    private final Connection connection;

    public WebsocketDuplexConnection(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "connection must not be null");
    }

    public void dispose() {
        this.connection.dispose();
    }

    public boolean isDisposed() {
        return this.connection.isDisposed();
    }

    public Mono<Void> onClose() {
        return this.connection.onDispose();
    }

    public Flux<Frame> receive() {
        return this.connection.inbound().receive().map(buf -> {
            CompositeByteBuf composite = this.connection.channel().alloc().compositeBuffer();
            ByteBuf length = Unpooled.wrappedBuffer((byte[])new byte[3]);
            FrameHeaderFlyweight.encodeLength((ByteBuf)length, (int)0, (int)buf.readableBytes());
            composite.addComponents(true, new ByteBuf[]{length, buf.retain()});
            return Frame.from((ByteBuf)composite);
        });
    }

    public Mono<Void> send(Publisher<Frame> frames) {
        return Flux.from(frames).concatMap(this::sendOne).then();
    }

    public Mono<Void> sendOne(Frame frame) {
        return this.connection.outbound().sendObject((Object)new BinaryWebSocketFrame(frame.content().skipBytes(3))).then();
    }
}

