/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.client;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.RSocketLengthCodec;
import io.rsocket.transport.netty.TcpDuplexConnection;
import java.net.InetSocketAddress;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpClient;

public final class TcpClientTransport
implements ClientTransport {
    private final TcpClient client;

    private TcpClientTransport(TcpClient client) {
        this.client = client;
    }

    public static TcpClientTransport create(int port) {
        TcpClient tcpClient = TcpClient.create().port(port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(String bindAddress, int port) {
        Objects.requireNonNull(bindAddress, "bindAddress must not be null");
        TcpClient tcpClient = TcpClient.create().host(bindAddress).port(port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        TcpClient tcpClient = TcpClient.create().addressSupplier(() -> address);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(TcpClient client) {
        Objects.requireNonNull(client, "client must not be null");
        return new TcpClientTransport(client);
    }

    public Mono<DuplexConnection> connect(int mtu) {
        return this.client.doOnConnected(c -> c.addHandlerLast((ChannelHandler)new RSocketLengthCodec())).connect().map(c -> {
            if (mtu > 0) {
                return new FragmentationDuplexConnection((DuplexConnection)new TcpDuplexConnection((Connection)c, false), ByteBufAllocator.DEFAULT, mtu, true);
            }
            return new TcpDuplexConnection((Connection)c);
        });
    }
}

