/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.rsocket.internal.BaseDuplexConnection;
import io.rsocket.transport.netty.SendPublisher;
import java.util.Objects;
import java.util.Queue;
import org.reactivestreams.Publisher;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.util.concurrent.Queues;

public final class WebsocketDuplexConnection
extends BaseDuplexConnection {
    private final Connection connection;

    public WebsocketDuplexConnection(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "connection must not be null");
        connection.channel().closeFuture().addListener(future -> {
            if (!this.isDisposed()) {
                this.dispose();
            }
        });
    }

    protected void doOnClose() {
        if (!this.connection.isDisposed()) {
            this.connection.dispose();
        }
    }

    public Flux<ByteBuf> receive() {
        return this.connection.inbound().receive().map(ByteBuf::retain);
    }

    public Mono<Void> send(Publisher<ByteBuf> frames) {
        return Flux.from(frames).transform(frameFlux -> {
            if (frameFlux instanceof Fuseable.QueueSubscription) {
                Fuseable.QueueSubscription queueSubscription = (Fuseable.QueueSubscription)frameFlux;
                queueSubscription.requestFusion(2);
                return new SendPublisher<BinaryWebSocketFrame>((Queue<ByteBuf>)queueSubscription, (Publisher<ByteBuf>)frameFlux, this.connection.channel(), this::toBinaryWebSocketFrame, binaryWebSocketFrame -> binaryWebSocketFrame.content().readableBytes());
            }
            return new SendPublisher<BinaryWebSocketFrame>((Queue)Queues.small().get(), (Publisher<ByteBuf>)frameFlux, this.connection.channel(), this::toBinaryWebSocketFrame, binaryWebSocketFrame -> binaryWebSocketFrame.content().readableBytes());
        }).then();
    }

    private BinaryWebSocketFrame toBinaryWebSocketFrame(ByteBuf frame) {
        return new BinaryWebSocketFrame(frame.retain());
    }
}

