/*
 * Decompiled with CFR 0.152.
 */
package io.ruck.prefsfx;

import io.ruck.prefsfx.PreferenceContext;
import io.ruck.prefsfx.PreferencePropertyFactory;
import io.ruck.prefsfx.StackTraceHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;

public final class PreferencePropertyBinder {
    private static final Logger LOG = Logger.getLogger(PreferencePropertyFactory.class.getName());

    private PreferencePropertyBinder() {
    }

    public static void bind(BooleanProperty prop, String valuename, boolean def) {
        Preferences preferences = PreferencePropertyBinder.getPreferences();
        prop.set(preferences.getBoolean(valuename, def));
        prop.addListener((o, ov, nv) -> {
            preferences.putBoolean(valuename, (boolean)nv);
            PreferencePropertyBinder.flush(preferences);
        });
    }

    public static void bind(DoubleProperty prop, String valuename, double def) {
        Preferences preferences = PreferencePropertyBinder.getPreferences();
        prop.set(preferences.getDouble(valuename, def));
        prop.addListener((o, ov, nv) -> {
            preferences.putDouble(valuename, nv.doubleValue());
            PreferencePropertyBinder.flush(preferences);
        });
    }

    public static void bind(FloatProperty prop, String valuename, float def) {
        Preferences preferences = PreferencePropertyBinder.getPreferences();
        prop.set(preferences.getFloat(valuename, def));
        prop.addListener((o, ov, nv) -> {
            preferences.putFloat(valuename, nv.floatValue());
            PreferencePropertyBinder.flush(preferences);
        });
    }

    public static void bind(IntegerProperty prop, String valuename, int def) {
        Preferences preferences = PreferencePropertyBinder.getPreferences();
        prop.set(preferences.getInt(valuename, def));
        prop.addListener((o, ov, nv) -> {
            preferences.putInt(valuename, nv.intValue());
            PreferencePropertyBinder.flush(preferences);
        });
    }

    public static void bind(LongProperty prop, String valuename, long def) {
        Preferences preferences = PreferencePropertyBinder.getPreferences();
        prop.set(preferences.getLong(valuename, def));
        prop.addListener((o, ov, nv) -> {
            preferences.putLong(valuename, nv.longValue());
            PreferencePropertyBinder.flush(preferences);
        });
    }

    private static Preferences getPreferences() {
        Class<?> caller = StackTraceHelper.getCallerClass();
        PreferenceContext context = PreferenceContext.getContext(caller.getName());
        return context.getPreferences();
    }

    private static void flush(Preferences p) {
        try {
            p.flush();
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.WARNING, ex.getMessage().replaceAll("\n", "\\n"), ex);
        }
    }
}

