/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.sun.source.util.DocTreePath;
import io.sarl.docs.doclet2.framework.CustomTagParser;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.framework.ExternalLinkManager;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.framework.TagletManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.eclipse.xtext.util.JavaVersion;

public abstract class AbstractDoclet
implements Doclet {
    private final WeakReference<Doclet> parent;
    private Reporter reporter = new IddleReporter();
    private SourceVersion sourceVersion;
    private ElementUtils elementUtils;
    private TagletManager tagletManager;
    private CustomTagParser customTagParser;
    private ExternalLinkManager externalLinkManager;

    public AbstractDoclet(Doclet parent) {
        this.parent = parent == null ? null : new WeakReference<Doclet>(parent);
    }

    @Inject
    public void setTagletManager(TagletManager manager) {
        this.tagletManager = manager;
    }

    public TagletManager getTagletManager() {
        return this.tagletManager;
    }

    @Inject
    public void setCustomTagParser(CustomTagParser parser) {
        this.customTagParser = parser;
    }

    public CustomTagParser getCustomTagParser() {
        return this.customTagParser;
    }

    @Inject
    public void setExternalLinkManager(ExternalLinkManager manager) {
        this.externalLinkManager = manager;
    }

    public ExternalLinkManager getExternalLinkManager() {
        return this.externalLinkManager;
    }

    @Inject
    public void setElementUtils(ElementUtils utils) {
        this.elementUtils = utils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    public Doclet getParent() {
        return this.parent == null ? null : (Doclet)this.parent.get();
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    @Override
    public String getName() {
        return "SARL-HTML";
    }

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        return Collections.emptySet();
    }

    protected SourceVersion determineSourceVersion() {
        JavaVersion version = JavaVersion.fromQualifier((String)"21");
        if (version != null) {
            switch (version) {
                case JAVA21: {
                    return SourceVersion.RELEASE_21;
                }
                case JAVA17: {
                    return SourceVersion.RELEASE_17;
                }
                case JAVA11: {
                    return SourceVersion.RELEASE_11;
                }
                case JAVA10: {
                    return SourceVersion.RELEASE_10;
                }
                case JAVA9: {
                    return SourceVersion.RELEASE_9;
                }
                case JAVA8: {
                    return SourceVersion.RELEASE_8;
                }
            }
            throw new UnsupportedClassVersionError();
        }
        return SourceVersion.latestSupported();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        if (this.sourceVersion == null) {
            this.sourceVersion = this.determineSourceVersion();
        }
        return this.sourceVersion;
    }

    @Override
    public final boolean run(DocletEnvironment environment) {
        try {
            if (environment instanceof SarlDocletEnvironment) {
                SarlDocletEnvironment sarlEnvironment = (SarlDocletEnvironment)environment;
                this.getElementUtils().setElements(sarlEnvironment.getElementUtils());
                this.getElementUtils().setTypes(sarlEnvironment.getTypeUtils());
                this.getTagletManager().init(sarlEnvironment, this);
                return this.generate(sarlEnvironment);
            }
        }
        catch (Exception ex) {
            Reporter rep = this.getReporter();
            if (rep == null) {
                throw new RuntimeException(ex);
            }
            StringWriter writer = new StringWriter();
            try (PrintWriter printWriter = new PrintWriter(writer);){
                String msg = ex.getLocalizedMessage();
                if (Strings.isNullOrEmpty((String)msg)) {
                    msg = ex.getMessage();
                }
                if (Strings.isNullOrEmpty((String)msg)) {
                    msg = ex.getClass().getName();
                }
                printWriter.println(msg);
                ex.printStackTrace(printWriter);
            }
            rep.print(Diagnostic.Kind.ERROR, writer.toString());
        }
        return false;
    }

    protected abstract boolean generate(SarlDocletEnvironment var1) throws Exception;

    private static class IddleReporter
    implements Reporter {
        private IddleReporter() {
        }

        @Override
        public void print(Diagnostic.Kind kind, String msg) {
        }

        @Override
        public void print(Diagnostic.Kind kind, DocTreePath path, String msg) {
        }

        @Override
        public void print(Diagnostic.Kind kind, Element e, String msg) {
        }
    }
}

