/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jdk.javadoc.doclet.Taglet;

public enum CustomTagLocation {
    EVERYWHERE('a'){

        @Override
        public Taglet.Location[] toJavadocLocation() {
            ArrayList<Taglet.Location> list = new ArrayList<Taglet.Location>();
            for (CustomTagLocation location : 1.getAllActiveLocations()) {
                list.addAll(Arrays.asList(location.toJavadocLocation()));
            }
            return list.toArray(new Taglet.Location[list.size()]);
        }
    }
    ,
    OVERVIEW('o'){

        @Override
        public Taglet.Location[] toJavadocLocation() {
            return new Taglet.Location[]{Taglet.Location.OVERVIEW};
        }
    }
    ,
    PACKAGE('p'){

        @Override
        public Taglet.Location[] toJavadocLocation() {
            return new Taglet.Location[]{Taglet.Location.PACKAGE};
        }
    }
    ,
    TYPE('t'){

        @Override
        public Taglet.Location[] toJavadocLocation() {
            return new Taglet.Location[]{Taglet.Location.TYPE};
        }
    }
    ,
    CONSTRUCTOR('c'){

        @Override
        public Taglet.Location[] toJavadocLocation() {
            return new Taglet.Location[]{Taglet.Location.CONSTRUCTOR};
        }
    }
    ,
    METHOD('m'){

        @Override
        public Taglet.Location[] toJavadocLocation() {
            return new Taglet.Location[]{Taglet.Location.METHOD};
        }
    }
    ,
    FIELD('t'){

        @Override
        public Taglet.Location[] toJavadocLocation() {
            return new Taglet.Location[]{Taglet.Location.FIELD};
        }
    }
    ,
    MODULE('u'){

        @Override
        public Taglet.Location[] toJavadocLocation() {
            return new Taglet.Location[]{Taglet.Location.MODULE};
        }
    }
    ,
    DISABLED('X'){

        @Override
        public Taglet.Location[] toJavadocLocation() {
            return new Taglet.Location[0];
        }
    };

    private final char symbol;

    private CustomTagLocation(char symbol) {
        this.symbol = symbol;
    }

    public abstract Taglet.Location[] toJavadocLocation();

    public static CustomTagLocation valueOf(char symbol) {
        for (CustomTagLocation location : CustomTagLocation.values()) {
            if (location.symbol != symbol) continue;
            return location;
        }
        return null;
    }

    public static List<CustomTagLocation> parse(String specification) {
        ArrayList<CustomTagLocation> list = new ArrayList<CustomTagLocation>();
        if (!Strings.isNullOrEmpty((String)specification)) {
            for (char symbol : specification.toCharArray()) {
                CustomTagLocation location = CustomTagLocation.valueOf(symbol);
                if (location == null) continue;
                list.add(location);
            }
        }
        return list;
    }

    public static List<CustomTagLocation> getAllActiveLocations() {
        return Arrays.asList(CustomTagLocation.values()).stream().filter(it -> it != DISABLED && it != EVERYWHERE).collect(Collectors.toList());
    }
}

