/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import com.google.common.base.Strings;
import io.sarl.docs.doclet2.framework.CustomTag;
import io.sarl.docs.doclet2.framework.CustomTagLocation;
import io.sarl.docs.doclet2.framework.CustomTagParser;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomTagParserImpl
implements CustomTagParser {
    private static final Pattern FULL_PATTERN = Pattern.compile("^([^:]+):([^:]+:):([^:]+)$");
    private static final Pattern SIMPLE_PATTERN = Pattern.compile("^([^:]+)$");

    @Override
    public CustomTag parse(String customTagDescription, CustomTagLocation defaultLocation, String defaultHeader) {
        if (customTagDescription != null) {
            String name;
            Matcher matcher1;
            Matcher matcher0 = FULL_PATTERN.matcher(customTagDescription);
            if (matcher0.matches()) {
                List<CustomTagLocation> locations;
                String name2 = matcher0.group(1);
                if (!Strings.isNullOrEmpty((String)name2) && !(locations = CustomTagLocation.parse(matcher0.group(2))).contains((Object)CustomTagLocation.DISABLED)) {
                    if (locations.isEmpty()) {
                        locations.add(CustomTagLocation.EVERYWHERE);
                    }
                    String header = Strings.nullToEmpty((String)matcher0.group(3));
                    return new CustomTag(name2, locations, header);
                }
            } else if (defaultLocation != null && (matcher1 = SIMPLE_PATTERN.matcher(customTagDescription)).matches() && !Strings.isNullOrEmpty((String)(name = matcher1.group(1)))) {
                List<CustomTagLocation> allLocations = defaultLocation == CustomTagLocation.EVERYWHERE ? CustomTagLocation.getAllActiveLocations() : Collections.singletonList(defaultLocation);
                return new CustomTag(name, allLocations, defaultHeader);
            }
        }
        return null;
    }
}

