/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import com.google.inject.Provider;
import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.InlineTagTree;
import com.sun.source.util.DocTrees;
import io.sarl.docs.doclet2.framework.ApidocExcluder;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.taglets.block.ExcludeFromApidocTaglet;
import io.sarl.docs.doclet2.html.taglets.block.HiddenTaglet;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.lang.core.util.SarlUtils;
import java.util.List;
import javax.lang.model.element.Element;

public class DefaultApidocExcluder
implements ApidocExcluder {
    private Provider<SarlDocletEnvironment> googleEnvironmentProvider;
    private SarlDocletEnvironment environment;

    public DefaultApidocExcluder(Provider<SarlDocletEnvironment> environmentProvider) {
        this.googleEnvironmentProvider = environmentProvider;
    }

    public SarlDocletEnvironment getDocletEnvironment() {
        if (this.environment == null) {
            this.environment = (SarlDocletEnvironment)this.googleEnvironmentProvider.get();
        }
        return this.environment;
    }

    protected boolean isExcluded(String tagName) {
        return ExcludeFromApidocTaglet.TAG_NAME.equalsIgnoreCase(tagName) || HiddenTaglet.TAG_NAME.equalsIgnoreCase(tagName);
    }

    @Override
    public boolean isExcluded(Element element) {
        List<? extends DocTree> nodes;
        if (SarlUtils.isHiddenMember((String)element.getSimpleName().toString())) {
            return true;
        }
        if (element.getAnnotation(SyntheticMember.class) != null) {
            return true;
        }
        SarlDocletEnvironment env = this.getDocletEnvironment();
        DocTrees tree = env.getDocTrees();
        DocCommentTree comment = tree.getDocCommentTree(element);
        if (comment != null && (nodes = comment.getBlockTags()) != null) {
            for (DocTree docTree : nodes) {
                BlockTagTree tag;
                InlineTagTree tag2;
                if (!(docTree instanceof InlineTagTree ? this.isExcluded((tag2 = (InlineTagTree)docTree).getTagName()) : docTree instanceof BlockTagTree && this.isExcluded((tag = (BlockTagTree)docTree).getTagName()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTranslatableToTag(Element element) {
        return element.getAnnotation(SyntheticMember.class) != null;
    }
}

