/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import com.google.inject.Inject;
import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import io.sarl.docs.doclet2.framework.DocUtils;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.framework.TypeHierarchy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import jdk.javadoc.doclet.Taglet;

public class DocUtilsImpl
implements DocUtils {
    private ElementUtils elementUtils;
    private TypeHierarchy typeHierarchy;

    @Inject
    public void setTypeHierarchy(TypeHierarchy utils) {
        this.typeHierarchy = utils;
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }

    @Inject
    public void setElementUtils(ElementUtils utils) {
        this.elementUtils = utils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public List<? extends DocTree> getTypeParameterComment(Element element, String parameterElement, SarlDocletEnvironment environment) {
        DocCommentTree commentTree = environment.getDocTrees().getDocCommentTree(element);
        if (commentTree != null) {
            for (DocTree docTree : commentTree.getBlockTags()) {
                ParamTree paramTag;
                if (!(docTree instanceof ParamTree) || !(paramTag = (ParamTree)docTree).isTypeParameter() || !parameterElement.equals(paramTag.getName().toString())) continue;
                return paramTag.getDescription();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends DocTree> getCommentForDeprecatedTag(DocTree tree) {
        final ArrayList documentation = new ArrayList();
        tree.accept(new SimpleDocTreeVisitor<Void, Void>(this){

            @Override
            public Void visitDeprecated(DeprecatedTree node, Void p) {
                documentation.addAll(node.getBody());
                return null;
            }
        }, null);
        return documentation;
    }

    @Override
    public List<? extends BlockTagTree> getBlockTags(Element element, DocTree.Kind type, SarlDocletEnvironment environment) {
        ArrayList<BlockTagTree> list = new ArrayList<BlockTagTree>();
        DocCommentTree commentTree = environment.getDocTrees().getDocCommentTree(element);
        if (commentTree != null) {
            for (DocTree docTree : commentTree.getBlockTags()) {
                if (docTree.getKind() != type || !(docTree instanceof BlockTagTree)) continue;
                list.add((BlockTagTree)docTree);
            }
        }
        return list;
    }

    @Override
    public List<? extends BlockTagTree> getBlockTags(Element element, SarlDocletEnvironment environment) {
        ArrayList<BlockTagTree> list = new ArrayList<BlockTagTree>();
        DocCommentTree commentTree = environment.getDocTrees().getDocCommentTree(element);
        if (commentTree != null) {
            for (DocTree docTree : commentTree.getBlockTags()) {
                if (!(docTree instanceof BlockTagTree)) continue;
                list.add((BlockTagTree)docTree);
            }
        }
        return list;
    }

    @Override
    public Taglet.Location getTagletLocation(Element element) {
        if (element != null) {
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    return Taglet.Location.CONSTRUCTOR;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return Taglet.Location.TYPE;
                }
                case ENUM_CONSTANT: 
                case EXCEPTION_PARAMETER: 
                case FIELD: 
                case LOCAL_VARIABLE: 
                case PARAMETER: 
                case RESOURCE_VARIABLE: 
                case TYPE_PARAMETER: {
                    return Taglet.Location.FIELD;
                }
                case INSTANCE_INIT: 
                case METHOD: 
                case STATIC_INIT: {
                    return Taglet.Location.METHOD;
                }
                case MODULE: {
                    return Taglet.Location.MODULE;
                }
                case PACKAGE: {
                    return Taglet.Location.PACKAGE;
                }
            }
        }
        return Taglet.Location.OVERVIEW;
    }

    @Override
    public List<? extends DocTree> getInheritedDocumentation(Element element, SarlDocletEnvironment environment) {
        List<? extends DocTree> doc1;
        ArrayList<? extends DocTree> doc = new ArrayList<DocTree>();
        DocCommentTree doc0 = this.getInheritedFullDocumentation(element, environment);
        if (doc0 != null && (doc1 = doc0.getFullBody()) != null) {
            doc.addAll(doc1);
        }
        return doc;
    }

    @Override
    public DocCommentTree getInheritedFullDocumentation(Element element, SarlDocletEnvironment environment) {
        Collection<? extends Element> inheritedElements;
        TypeElement type = this.getElementUtils().getEnclosingTypeElement(element);
        Elements elts = environment.getElementUtils();
        if (element instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)element;
            inheritedElements = this.getTypeHierarchy().getInheritedElements(type, true, true, false, false, environment, it -> it instanceof ExecutableElement && elts.overrides(ee, (ExecutableElement)it, type));
        } else {
            inheritedElements = this.getTypeHierarchy().getInheritedElements(type, true, true, false, false, environment, it -> elts.hides(element, (Element)it));
        }
        if (!inheritedElements.isEmpty()) {
            for (Element element2 : inheritedElements) {
                DocCommentTree doc0 = environment.getDocTrees().getDocCommentTree(element2);
                if (doc0 == null) continue;
                return doc0;
            }
        }
        return null;
    }
}

