/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import com.google.inject.Inject;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.ProvidesTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.UsesTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import io.sarl.docs.doclet2.framework.DocUtils;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.framework.QualifiedNameSetBuilder;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.annotation.PrivateAPI;
import io.sarl.lang.jvmmodel.IDefaultVisibilityProvider;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import java.lang.annotation.Documented;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor9;
import javax.lang.model.util.ElementKindVisitor9;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import javax.lang.model.util.Types;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.util.Strings;

public class ElementUtilsImpl
implements ElementUtils {
    public static final String DEFAULT_ELEMENT_NAME = "<Unnamed>";
    private static final String SPACE = " ";
    private static final Pattern MEMBER_NAME_PATTERN = Pattern.compile("(.+?)(?:\\((.*)\\))?");
    private Map<String, TypeMirror> typeCache = new HashMap<String, TypeMirror>();
    private Elements elementUtils;
    private Types typeUtils;
    private DocUtils docUtils;
    private SARLGrammarKeywordAccess keywords;
    private TypeMirror agentTypeCache;
    private TypeMirror behaviorTypeCache;
    private TypeMirror skillTypeCache;
    private TypeMirror eventTypeCache;
    private TypeMirror capacityTypeCache;
    private final Comparator<ModuleElement> moduleElementComparator = (a, b) -> {
        String nb;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        if (b == null) {
            return Integer.MAX_VALUE;
        }
        String na = a.getQualifiedName().toString();
        int cmp = na.compareToIgnoreCase(nb = b.getQualifiedName().toString());
        if (cmp != 0) {
            return cmp;
        }
        return na.compareTo(nb);
    };
    private final Comparator<PackageElement> packageElementComparator = (a, b) -> {
        String nb;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        if (b == null) {
            return Integer.MAX_VALUE;
        }
        String na = a.getQualifiedName().toString();
        int cmp = na.compareToIgnoreCase(nb = b.getQualifiedName().toString());
        if (cmp != 0) {
            return cmp;
        }
        return na.compareTo(nb);
    };
    private final Comparator<TypeElement> typeElementComparator = (a, b) -> {
        String nb;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        if (b == null) {
            return Integer.MAX_VALUE;
        }
        String na = a.getQualifiedName().toString();
        int cmp = na.compareToIgnoreCase(nb = b.getQualifiedName().toString());
        if (cmp != 0) {
            return cmp;
        }
        return na.compareTo(nb);
    };
    private final Comparator<TypeElement> typeElementBasenameComparator = (a, b) -> {
        String nb0;
        String nb;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        if (b == null) {
            return Integer.MAX_VALUE;
        }
        String na = a.getSimpleName().toString();
        int cmp = na.compareToIgnoreCase(nb = b.getSimpleName().toString());
        if (cmp != 0) {
            return cmp;
        }
        String na0 = a.getQualifiedName().toString();
        int cmp0 = na0.compareToIgnoreCase(nb0 = b.getQualifiedName().toString());
        if (cmp0 != 0) {
            return cmp0;
        }
        return na0.compareTo(nb0);
    };
    private final Comparator<TypeMirror> typeMirrorComparator = (a, b) -> {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        if (b == null) {
            return Integer.MAX_VALUE;
        }
        return this.typeElementComparator.compare(this.asTypeElement((TypeMirror)a, this.typeUtils), this.asTypeElement((TypeMirror)b, this.typeUtils));
    };
    private final Comparator<ExecutableElement> executableComparator = (a, b) -> {
        String nb0;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        if (b == null) {
            return Integer.MAX_VALUE;
        }
        String na0 = a.getSimpleName().toString();
        int nameCmp = na0.compareToIgnoreCase(nb0 = b.getSimpleName().toString());
        if (nameCmp != 0) {
            return nameCmp;
        }
        nameCmp = na0.compareTo(nb0);
        if (nameCmp != 0) {
            return nameCmp;
        }
        int nparamCmp = a.getParameters().size() - b.getParameters().size();
        if (nparamCmp != 0) {
            return nparamCmp;
        }
        assert (a.getParameters().size() == b.getParameters().size());
        int sz = a.getParameters().size();
        for (int i = 0; i < sz; ++i) {
            TypeMirror tb;
            VariableElement pa = a.getParameters().get(i);
            VariableElement pb = b.getParameters().get(i);
            TypeMirror ta = pa.asType();
            int cmp = this.typeMirrorComparator.compare(ta, tb = pb.asType());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    };
    private final Comparator<VariableElement> variableComparator = (a, b) -> {
        String nb0;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        if (b == null) {
            return Integer.MAX_VALUE;
        }
        String na0 = a.getSimpleName().toString();
        int cmp = na0.compareToIgnoreCase(nb0 = b.getSimpleName().toString());
        if (cmp != 0) {
            return cmp;
        }
        return na0.compareTo(nb0);
    };

    protected TypeMirror getAgentType() {
        if (this.agentTypeCache == null) {
            this.agentTypeCache = this.elementUtils.getTypeElement(Agent.class.getName()).asType();
        }
        return this.agentTypeCache;
    }

    protected TypeMirror getBehaviorType() {
        if (this.behaviorTypeCache == null) {
            this.behaviorTypeCache = this.elementUtils.getTypeElement(Behavior.class.getName()).asType();
        }
        return this.behaviorTypeCache;
    }

    protected TypeMirror getSkillType() {
        if (this.skillTypeCache == null) {
            this.skillTypeCache = this.elementUtils.getTypeElement(Skill.class.getName()).asType();
        }
        return this.skillTypeCache;
    }

    protected TypeMirror getEventType() {
        if (this.eventTypeCache == null) {
            this.eventTypeCache = this.elementUtils.getTypeElement(Event.class.getName()).asType();
        }
        return this.eventTypeCache;
    }

    protected TypeMirror getCapacityType() {
        if (this.capacityTypeCache == null) {
            this.capacityTypeCache = this.elementUtils.getTypeElement(Capacity.class.getName()).asType();
        }
        return this.capacityTypeCache;
    }

    @Inject
    public void setDocUtils(DocUtils utils) {
        this.docUtils = utils;
    }

    public DocUtils getDocUtils() {
        return this.docUtils;
    }

    @Inject
    public void setSARLGrammarKeywordAccess(SARLGrammarKeywordAccess accessor) {
        this.keywords = accessor;
    }

    public SARLGrammarKeywordAccess getSARLGrammarKeywordAccess() {
        return this.keywords;
    }

    @Override
    public void setElements(Elements elementUtils) {
        this.elementUtils = elementUtils;
    }

    @Override
    public void setTypes(Types typeUtils) {
        this.typeUtils = typeUtils;
    }

    private static boolean isNoType(TypeMirror t) {
        return t.getKind() == TypeKind.NONE;
    }

    @Override
    public TypeMirror getSymbol(String signature, QualifiedNameSetBuilder findQualifiedNames) {
        boolean useQualifiedNames;
        LinkedList<String> signatures = new LinkedList<String>();
        signatures.addLast(signature);
        boolean bl = useQualifiedNames = findQualifiedNames != null;
        while (!signatures.isEmpty()) {
            String sig = (String)signatures.removeFirst();
            TypeMirror type = this.typeCache.get(sig);
            if (type != null) {
                return type;
            }
            TypeElement typeElement = this.elementUtils.getTypeElement(sig);
            if (typeElement != null && (type = typeElement.asType()) != null) {
                this.typeCache.put(sig, type);
                return type;
            }
            if (!useQualifiedNames) continue;
            assert (findQualifiedNames != null);
            useQualifiedNames = false;
            Set<String> qualifiedNames = findQualifiedNames.buildCandidateList(sig);
            if (qualifiedNames == null) continue;
            for (String qn : qualifiedNames) {
                signatures.addLast(qn);
            }
        }
        return null;
    }

    @Override
    public TypeMirror getObjectType() {
        return this.getSymbol(Object.class.getName());
    }

    public static boolean isAnnotated(TypeMirror e) {
        return !e.getAnnotationMirrors().isEmpty();
    }

    @Override
    public TypeElement asTypeElement(TypeMirror type, final Types typeUtils) {
        return (TypeElement)new SimpleTypeVisitor9<TypeElement, Void>(this){

            @Override
            public TypeElement visitDeclared(DeclaredType t, Void p) {
                return (TypeElement)t.asElement();
            }

            @Override
            public TypeElement visitArray(ArrayType t, Void p) {
                return (TypeElement)this.visit(t.getComponentType());
            }

            @Override
            public TypeElement visitTypeVariable(TypeVariable t, Void p) {
                if (ElementUtilsImpl.isAnnotated(t)) {
                    return (TypeElement)this.visit(t.asElement().asType());
                }
                return (TypeElement)this.visit(typeUtils.erasure(t));
            }

            @Override
            public TypeElement visitWildcard(WildcardType t, Void p) {
                return (TypeElement)this.visit(typeUtils.erasure(t));
            }

            @Override
            public TypeElement visitError(ErrorType t, Void p) {
                return (TypeElement)t.asElement();
            }

            @Override
            protected TypeElement defaultAction(TypeMirror e, Void p) {
                return (TypeElement)super.defaultAction(e, p);
            }
        }.visit(type);
    }

    @Override
    public boolean isPublic(Element element) {
        return element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isProtected(Element element) {
        return element.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    protected Element toIncludableElement(Element element) {
        switch (element.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case MODULE: 
            case PACKAGE: {
                return element;
            }
            case CONSTRUCTOR: 
            case ENUM_CONSTANT: 
            case EXCEPTION_PARAMETER: 
            case FIELD: 
            case INSTANCE_INIT: 
            case LOCAL_VARIABLE: 
            case METHOD: 
            case PARAMETER: 
            case RESOURCE_VARIABLE: 
            case STATIC_INIT: 
            case TYPE_PARAMETER: {
                return this.getEnclosingTypeElement(element);
            }
        }
        return null;
    }

    @Override
    public boolean isExternal(Element element, SarlDocletEnvironment environment) {
        PackageElement packageElement = environment.getElementUtils().getPackageOf(element);
        if (packageElement == null || packageElement.isUnnamed()) {
            return false;
        }
        Element elt = this.toIncludableElement(element);
        return !environment.getIncludedElements().contains(elt);
    }

    @Override
    public boolean isLinkable(TypeElement typeElem, SarlDocletEnvironment environment) {
        return typeElem != null && environment.isIncluded(typeElem) || this.isExternal(typeElem, environment) && (this.isPublic(typeElem) || this.isProtected(typeElem));
    }

    @Override
    public TypeMirror getFirstVisibleSuperType(TypeElement typeElement, boolean assumeObject, SarlDocletEnvironment environment) {
        TypeMirror supersuperType;
        TypeElement supersuperClass;
        TypeMirror superType = typeElement.getSuperclass();
        if (ElementUtilsImpl.isNoType(superType)) {
            if (assumeObject) {
                superType = this.getObjectType();
            } else {
                return null;
            }
        }
        TypeElement superClass = this.asTypeElement(superType, environment.getTypeUtils());
        while (!(superClass == null || environment.isIncluded(superClass) && (this.isPublic(superClass) || this.isLinkable(superClass, environment)) || (supersuperClass = this.asTypeElement(supersuperType = superClass.getSuperclass(), environment.getTypeUtils())) == null || supersuperClass.getQualifiedName().equals(superClass.getQualifiedName()))) {
            superType = supersuperType;
            superClass = supersuperClass;
        }
        if (typeElement.asType().equals(superType)) {
            return null;
        }
        return superType;
    }

    @Override
    public String getElementName(ModuleElement element) {
        if (element == null || element.isUnnamed()) {
            return DEFAULT_ELEMENT_NAME;
        }
        return element.getQualifiedName().toString();
    }

    @Override
    public String getElementName(PackageElement element) {
        if (element == null || element.isUnnamed()) {
            return DEFAULT_ELEMENT_NAME;
        }
        return element.getQualifiedName().toString();
    }

    @Override
    public SortedSet<? extends TypeMirror> getAllInterfaces(TypeElement typeElement, SarlDocletEnvironment environment) {
        LinkedList<TypeMirror> candidates = new LinkedList<TypeMirror>();
        TreeSet<TypeMirror> done = new TreeSet<TypeMirror>((a, b) -> a.toString().compareTo(b.toString()));
        TreeSet<TypeMirror> interfaces = new TreeSet<TypeMirror>((a, b) -> a.toString().compareTo(b.toString()));
        Types types = environment.getTypeUtils();
        TypeMirror superType = typeElement.getSuperclass();
        if (superType.getKind() != TypeKind.NONE) {
            candidates.add(superType);
        }
        candidates.addAll(typeElement.getInterfaces());
        while (!candidates.isEmpty()) {
            TypeMirror candidate = (TypeMirror)candidates.removeFirst();
            if (!done.add(candidate)) continue;
            TypeElement superElement = this.asTypeElement(candidate, types);
            if (superElement.getKind() == ElementKind.INTERFACE) {
                interfaces.add(candidate);
            } else {
                superType = superElement.getSuperclass();
                if (superType.getKind() != TypeKind.NONE) {
                    candidates.add(superType);
                }
            }
            candidates.addAll(superElement.getInterfaces());
        }
        return interfaces;
    }

    protected Modifier getDefaultVisibilityFor(Element element) {
        JvmVisibility jvmVisibility = JvmVisibility.PUBLIC;
        final Element enclosing = element.getEnclosingElement();
        if (enclosing != null) {
            final TypeMirror enclosingType = enclosing.asType();
            IDefaultVisibilityProvider.Tester tester = new IDefaultVisibilityProvider.Tester(){

                public boolean isInterface() {
                    return enclosing.getKind() == ElementKind.INTERFACE;
                }

                public boolean isEvent() {
                    return enclosing.getKind() == ElementKind.CLASS && ElementUtilsImpl.this.typeUtils.isAssignable(enclosingType, ElementUtilsImpl.this.getEventType());
                }

                public boolean isAnnotationType() {
                    return enclosing.getKind() == ElementKind.ANNOTATION_TYPE;
                }

                public boolean isAgent() {
                    return enclosing.getKind() == ElementKind.CLASS && ElementUtilsImpl.this.typeUtils.isAssignable(enclosingType, ElementUtilsImpl.this.getAgentType());
                }
            };
            switch (element.getKind()) {
                case ANNOTATION_TYPE: {
                    jvmVisibility = IDefaultVisibilityProvider.getAnnotationTypeDefaultVisibilityIn((IDefaultVisibilityProvider.Tester)tester);
                    break;
                }
                case CLASS: {
                    jvmVisibility = IDefaultVisibilityProvider.getClassDefaultVisibilityIn((IDefaultVisibilityProvider.Tester)tester);
                    break;
                }
                case ENUM: {
                    jvmVisibility = IDefaultVisibilityProvider.getEnumerationDefaultVisibilityIn((IDefaultVisibilityProvider.Tester)tester);
                    break;
                }
                case FIELD: {
                    jvmVisibility = IDefaultVisibilityProvider.getFieldDefaultVisibilityIn((IDefaultVisibilityProvider.Tester)tester);
                    break;
                }
                case INTERFACE: {
                    jvmVisibility = IDefaultVisibilityProvider.getInterfaceDefaultVisibilityIn((IDefaultVisibilityProvider.Tester)tester);
                    break;
                }
                case METHOD: {
                    jvmVisibility = IDefaultVisibilityProvider.getActionDefaultVisibilityIn((IDefaultVisibilityProvider.Tester)tester);
                    break;
                }
            }
        }
        switch (jvmVisibility) {
            case PRIVATE: {
                return Modifier.PRIVATE;
            }
            case PROTECTED: {
                return Modifier.PROTECTED;
            }
            case PUBLIC: {
                return Modifier.PUBLIC;
            }
        }
        return Modifier.DEFAULT;
    }

    @Override
    public String getVisibilityModifiersString(Element element, final boolean trailingSpace) {
        TreeSet<Modifier> modifierList = new TreeSet<Modifier>(element.getModifiers());
        ElementUtilsImpl.removeModifiersToIgnore(modifierList);
        final Modifier defaultVisibility = this.getDefaultVisibilityFor(element);
        return (String)new ElementKindVisitor9<String, SortedSet<Modifier>>(){
            final StringBuilder stringRepresentation = new StringBuilder();

            private void addVisibilityModifier(Set<Modifier> modifiers) {
                if (modifiers.contains((Object)Modifier.PUBLIC)) {
                    if (defaultVisibility == null || defaultVisibility != Modifier.PUBLIC) {
                        this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getPublicKeyword()).append(ElementUtilsImpl.SPACE);
                    }
                } else if (modifiers.contains((Object)Modifier.PROTECTED)) {
                    if (defaultVisibility == null || defaultVisibility != Modifier.PROTECTED) {
                        this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getProtectedKeyword()).append(ElementUtilsImpl.SPACE);
                    }
                } else if (modifiers.contains((Object)Modifier.PRIVATE)) {
                    if (defaultVisibility == null || defaultVisibility != Modifier.PRIVATE) {
                        this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getPrivateKeyword()).append(ElementUtilsImpl.SPACE);
                    }
                } else if (defaultVisibility == null) {
                    this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getPackageKeyword()).append(ElementUtilsImpl.SPACE);
                }
            }

            private String finalString(String s) {
                this.stringRepresentation.append(s);
                if (trailingSpace) {
                    if (this.stringRepresentation.lastIndexOf(ElementUtilsImpl.SPACE) == this.stringRepresentation.length() - 1) {
                        return this.stringRepresentation.toString();
                    }
                    return this.stringRepresentation.append(ElementUtilsImpl.SPACE).toString();
                }
                return this.stringRepresentation.toString().trim();
            }

            @Override
            public String visitTypeAsInterface(TypeElement elt, SortedSet<Modifier> param) {
                this.addVisibilityModifier(param);
                return this.finalString(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getInterfaceKeyword());
            }

            @Override
            public String visitTypeAsEnum(TypeElement elt, SortedSet<Modifier> param) {
                this.addVisibilityModifier(param);
                return this.finalString(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getEnumKeyword());
            }

            @Override
            public String visitTypeAsAnnotationType(TypeElement elt, SortedSet<Modifier> param) {
                this.addVisibilityModifier(param);
                return this.finalString(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getAnnotationKeyword());
            }

            @Override
            public String visitTypeAsClass(TypeElement elt, SortedSet<Modifier> param) {
                this.addVisibilityModifier(param);
                return this.finalString(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getClassKeyword());
            }

            @Override
            public String visitTypeAsRecord(TypeElement elt, SortedSet<Modifier> param) {
                this.addVisibilityModifier(param);
                return this.finalString("record");
            }

            @Override
            protected String defaultAction(Element elt, SortedSet<Modifier> param) {
                this.addVisibilityModifier(param);
                return this.stringRepresentation.toString().trim();
            }
        }.visit(element, modifierList);
    }

    private static void removeModifiersToIgnore(SortedSet<Modifier> modifierList) {
        modifierList.remove((Object)Modifier.NATIVE);
        modifierList.remove((Object)Modifier.STRICTFP);
        modifierList.remove((Object)Modifier.SYNCHRONIZED);
    }

    @Override
    public String getModifiersString(Element element, final boolean trailingSpace, final boolean showFinalModifier, final boolean showVarValModifier) {
        final TreeSet<Modifier> modifierList = new TreeSet<Modifier>(element.getModifiers());
        ElementUtilsImpl.removeModifiersToIgnore(modifierList);
        final Modifier defaultVisibility = this.getDefaultVisibilityFor(element);
        return (String)new ElementKindVisitor9<String, SortedSet<Modifier>>(){
            final StringBuilder stringRepresentation = new StringBuilder();

            private void addVisibilityModifier(Set<Modifier> modifiers) {
                if (modifiers.contains((Object)Modifier.PUBLIC)) {
                    if (defaultVisibility == null || defaultVisibility != Modifier.PUBLIC) {
                        this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getPublicKeyword()).append(ElementUtilsImpl.SPACE);
                    }
                } else if (modifiers.contains((Object)Modifier.PROTECTED)) {
                    if (defaultVisibility == null || defaultVisibility != Modifier.PROTECTED) {
                        this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getProtectedKeyword()).append(ElementUtilsImpl.SPACE);
                    }
                } else if (modifiers.contains((Object)Modifier.PRIVATE)) {
                    if (defaultVisibility == null || defaultVisibility != Modifier.PRIVATE) {
                        this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getPrivateKeyword()).append(ElementUtilsImpl.SPACE);
                    }
                } else if (defaultVisibility == null) {
                    this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getPackageKeyword()).append(ElementUtilsImpl.SPACE);
                }
            }

            private void addStaticModifier(Set<Modifier> modifiers) {
                if (modifiers.contains((Object)Modifier.STATIC)) {
                    this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getStaticStaticKeyword()).append(ElementUtilsImpl.SPACE);
                }
            }

            private void addAbstractModifier(Set<Modifier> modifiers, ElementKind elementType) {
                if (modifiers.contains((Object)Modifier.ABSTRACT) && elementType != ElementKind.INTERFACE) {
                    this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getAbstractKeyword()).append(ElementUtilsImpl.SPACE);
                }
            }

            private void addFinalModifier(Set<Modifier> modifiers) {
                if (modifiers.contains((Object)Modifier.FINAL) && showFinalModifier) {
                    this.stringRepresentation.append(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getFinalKeyword()).append(ElementUtilsImpl.SPACE);
                }
            }

            private void addVarValModifier(Set<Modifier> modifiers) {
                if (showVarValModifier) {
                    String kw = modifiers.contains((Object)Modifier.FINAL) ? ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getValKeyword() : ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getWriteableVarKeyword();
                    this.stringRepresentation.append(kw).append(ElementUtilsImpl.SPACE);
                }
            }

            private void addOtherModifiers(Set<Modifier> modifiers) {
                String str = modifierList.stream().filter(it -> it != null && it != Modifier.PUBLIC && it != Modifier.PROTECTED && it != Modifier.PRIVATE && it != Modifier.STATIC && it != Modifier.FINAL && it != Modifier.ABSTRACT).map(Modifier::toString).collect(Collectors.joining(ElementUtilsImpl.SPACE));
                this.stringRepresentation.append(str);
                if (!str.isEmpty()) {
                    this.stringRepresentation.append(ElementUtilsImpl.SPACE);
                }
            }

            private String addTypeModifier(String s) {
                this.stringRepresentation.append(s);
                if (trailingSpace) {
                    if (this.stringRepresentation.lastIndexOf(ElementUtilsImpl.SPACE) == this.stringRepresentation.length() - 1) {
                        return this.stringRepresentation.toString();
                    }
                    return this.stringRepresentation.append(ElementUtilsImpl.SPACE).toString();
                }
                return this.stringRepresentation.toString().trim();
            }

            private String getSarlSpecificInterfaceKeyword(TypeElement type) {
                TypeMirror tm = type.asType();
                if (ElementUtilsImpl.this.typeUtils.isAssignable(tm, ElementUtilsImpl.this.getCapacityType())) {
                    return ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getCapacityKeyword();
                }
                return null;
            }

            private String getSarlSpecificClassKeyword(TypeElement type) {
                TypeMirror tm = type.asType();
                if (ElementUtilsImpl.this.typeUtils.isAssignable(tm, ElementUtilsImpl.this.getAgentType())) {
                    return ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getAgentKeyword();
                }
                if (ElementUtilsImpl.this.typeUtils.isAssignable(tm, ElementUtilsImpl.this.getEventType())) {
                    return ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getEventKeyword();
                }
                if (ElementUtilsImpl.this.typeUtils.isAssignable(tm, ElementUtilsImpl.this.getBehaviorType())) {
                    return ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getBehaviorKeyword();
                }
                if (ElementUtilsImpl.this.typeUtils.isAssignable(tm, ElementUtilsImpl.this.getSkillType())) {
                    return ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getSkillKeyword();
                }
                return null;
            }

            private void addModifiersInStandardOrder(SortedSet<Modifier> param, ElementKind elementType) {
                this.addVisibilityModifier(param);
                this.addStaticModifier(param);
                this.addAbstractModifier(param, elementType);
                this.addFinalModifier(param);
                this.addVarValModifier(param);
                this.addOtherModifiers(param);
            }

            @Override
            public String visitTypeAsInterface(TypeElement elt, SortedSet<Modifier> param) {
                this.addModifiersInStandardOrder(param, elt.getKind());
                String sarlKw = this.getSarlSpecificInterfaceKeyword(elt);
                if (!Strings.isEmpty((String)sarlKw)) {
                    return this.addTypeModifier(sarlKw);
                }
                return this.addTypeModifier(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getInterfaceKeyword());
            }

            @Override
            public String visitTypeAsEnum(TypeElement elt, SortedSet<Modifier> param) {
                this.addModifiersInStandardOrder(param, elt.getKind());
                return this.addTypeModifier(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getEnumKeyword());
            }

            @Override
            public String visitTypeAsAnnotationType(TypeElement elt, SortedSet<Modifier> param) {
                this.addModifiersInStandardOrder(param, elt.getKind());
                return this.addTypeModifier(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getAnnotationKeyword());
            }

            @Override
            public String visitTypeAsClass(TypeElement elt, SortedSet<Modifier> param) {
                this.addModifiersInStandardOrder(param, elt.getKind());
                String sarlKw = this.getSarlSpecificClassKeyword(elt);
                if (!Strings.isEmpty((String)sarlKw)) {
                    return this.addTypeModifier(sarlKw);
                }
                return this.addTypeModifier(ElementUtilsImpl.this.getSARLGrammarKeywordAccess().getClassKeyword());
            }

            @Override
            public String visitTypeAsRecord(TypeElement elt, SortedSet<Modifier> param) {
                this.addModifiersInStandardOrder(param, elt.getKind());
                String sarlKw = this.getSarlSpecificClassKeyword(elt);
                if (!Strings.isEmpty((String)sarlKw)) {
                    return this.addTypeModifier(sarlKw);
                }
                return this.addTypeModifier("record");
            }

            @Override
            protected String defaultAction(Element elt, SortedSet<Modifier> param) {
                this.addModifiersInStandardOrder(param, elt.getKind());
                return this.stringRepresentation.toString().trim();
            }
        }.visit(element, modifierList);
    }

    @Override
    public String getFullyQualifiedName(Element e, final boolean outer) {
        return (String)new SimpleElementVisitor9<String, Void>(this){

            @Override
            public String visitModule(ModuleElement e, Void p) {
                return e.getQualifiedName().toString();
            }

            @Override
            public String visitPackage(PackageElement e, Void p) {
                return e.getQualifiedName().toString();
            }

            @Override
            public String visitType(TypeElement e, Void p) {
                return e.getQualifiedName().toString();
            }

            @Override
            protected String defaultAction(Element e, Void p) {
                String outerName;
                if (outer && !Strings.isEmpty((String)(outerName = (String)this.visit(e.getEnclosingElement())))) {
                    return outerName + "." + e.getSimpleName().toString();
                }
                return e.getSimpleName().toString();
            }
        }.visit(e);
    }

    @Override
    public String getLocalIdentifier(final Element e) {
        return (String)new SimpleElementVisitor9<String, Void>(){

            @Override
            public String visitExecutable(ExecutableElement e2, Void p) {
                StringBuilder basename = new StringBuilder();
                basename.append(e2.getSimpleName().toString());
                basename.append("(");
                boolean first = true;
                for (VariableElement variableElement : e2.getParameters()) {
                    if (first) {
                        first = false;
                    } else {
                        basename.append(",");
                    }
                    TypeMirror typeMirror = variableElement.asType();
                    TypeElement type = ElementUtilsImpl.this.asTypeElement(typeMirror, ElementUtilsImpl.this.typeUtils);
                    if (type != null) {
                        basename.append(type.getQualifiedName().toString());
                        continue;
                    }
                    basename.append(typeMirror.toString());
                }
                basename.append(")");
                return basename.toString();
            }

            @Override
            public String visitRecordComponent(RecordComponentElement elt, Void param) {
                return e.getSimpleName().toString();
            }

            @Override
            protected String defaultAction(Element e2, Void p) {
                return e2.getSimpleName().toString();
            }
        }.visit(e);
    }

    @Override
    public String getFullIdentifier(TypeMirror type) {
        return (String)new AbstractTypeVisitor9<String, Void>(){

            @Override
            public String visitPrimitive(PrimitiveType t, Void p) {
                return t.toString();
            }

            @Override
            public String visitNull(NullType t, Void p) {
                return "";
            }

            @Override
            public String visitArray(ArrayType t, Void p) {
                return (String)this.visit(t.getComponentType()) + "[]";
            }

            @Override
            public String visitDeclared(DeclaredType t, Void p) {
                return ElementUtilsImpl.this.getFullIdentifier(t.asElement());
            }

            @Override
            public String visitError(ErrorType t, Void p) {
                return "";
            }

            @Override
            public String visitTypeVariable(TypeVariable t, Void p) {
                TypeMirror tp = t.getUpperBound();
                if (tp == null) {
                    tp = t.getLowerBound();
                }
                if (tp == null || tp.getKind() == TypeKind.NULL || tp.getKind() == TypeKind.NONE) {
                    return Object.class.getName();
                }
                return (String)this.visit(tp);
            }

            @Override
            public String visitWildcard(WildcardType t, Void p) {
                return "";
            }

            @Override
            public String visitExecutable(ExecutableType t, Void p) {
                return "";
            }

            @Override
            public String visitNoType(NoType t, Void p) {
                return "";
            }

            @Override
            public String visitIntersection(IntersectionType t, Void p) {
                return "";
            }

            @Override
            public String visitUnion(UnionType t, Void p) {
                return "";
            }
        }.visit(type);
    }

    @Override
    public String getFullIdentifier(Element e) {
        return (String)new SimpleElementVisitor9<String, Void>(){

            @Override
            public String visitModule(ModuleElement e, Void p) {
                return e.getQualifiedName().toString();
            }

            @Override
            public String visitPackage(PackageElement e, Void p) {
                return e.getQualifiedName().toString();
            }

            @Override
            public String visitType(TypeElement e, Void p) {
                return e.getQualifiedName().toString();
            }

            @Override
            public String visitExecutable(ExecutableElement e, Void p) {
                StringBuilder basename = new StringBuilder();
                basename.append(e.getSimpleName().toString());
                basename.append("(");
                boolean first = true;
                for (VariableElement variableElement : e.getParameters()) {
                    if (first) {
                        first = false;
                    } else {
                        basename.append(",");
                    }
                    TypeMirror typeMirror = variableElement.asType();
                    TypeElement type = ElementUtilsImpl.this.asTypeElement(typeMirror, ElementUtilsImpl.this.typeUtils);
                    if (type != null) {
                        basename.append(type.getQualifiedName().toString());
                        continue;
                    }
                    basename.append(typeMirror.toString());
                }
                basename.append(")");
                String outerId = (String)this.visit(e.getEnclosingElement());
                if (!Strings.isEmpty((String)outerId)) {
                    return outerId + "." + basename.toString();
                }
                return basename.toString();
            }

            @Override
            protected String defaultAction(Element e, Void p) {
                String basename = e.getSimpleName().toString();
                String outerId = (String)this.visit(e.getEnclosingElement());
                if (!Strings.isEmpty((String)outerId)) {
                    return outerId + "." + basename;
                }
                return basename;
            }
        }.visit(e);
    }

    @Override
    public String getInnerTypeQualifiedName(Element e) {
        return (String)new SimpleElementVisitor9<String, Void>(this){

            @Override
            public String visitModule(ModuleElement e, Void p) {
                return e.getSimpleName().toString();
            }

            @Override
            public String visitPackage(PackageElement e, Void p) {
                return e.getSimpleName().toString();
            }

            @Override
            public String visitType(TypeElement e, Void p) {
                return this.build(e);
            }

            @Override
            protected String defaultAction(Element e, Void p) {
                return this.build(e);
            }

            private String build(Element e) {
                Element enclosing = e.getEnclosingElement();
                if (enclosing != null) {
                    return enclosing.getSimpleName().toString() + "." + e.getSimpleName().toString();
                }
                return e.getSimpleName().toString();
            }
        }.visit(e);
    }

    @Override
    public boolean isDocumentedAnnotation(TypeElement annotation) {
        for (AnnotationMirror annotationMirror : annotation.getAnnotationMirrors()) {
            if (!Documented.class.getName().equals(this.getFullyQualifiedName(annotationMirror.getAnnotationType().asElement(), true))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSynthetized(AnnotationMirror element) {
        try {
            Method method = this.getClass().getMethod("isSynthetized", new Class[0]);
            Object value = method.invoke((Object)element, new Object[0]);
            if (value instanceof Boolean) {
                Boolean cvalue = (Boolean)value;
                return cvalue;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isAnnotationArray(Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValues) {
        for (AnnotationValue annotationValue : annotationValues.values()) {
            boolean rvalue = (Boolean)new SimpleAnnotationValueVisitor9<Boolean, Void>(this){

                @Override
                public Boolean visitArray(List<? extends AnnotationValue> vals, Void p) {
                    if (vals.size() > 1 && vals.get(0) instanceof AnnotationMirror) {
                        return (Boolean)new SimpleAnnotationValueVisitor9<Boolean, Void>(this){

                            @Override
                            public Boolean visitAnnotation(AnnotationMirror a, Void p) {
                                return Boolean.TRUE;
                            }

                            @Override
                            protected Boolean defaultAction(Object o, Void p) {
                                return Boolean.FALSE;
                            }
                        }.visit(vals.get(0));
                    }
                    return Boolean.FALSE;
                }

                @Override
                protected Boolean defaultAction(Object o, Void p) {
                    return Boolean.FALSE;
                }
            }.visit(annotationValue);
            if (!rvalue) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDimension(TypeMirror type) {
        return (String)new SimpleTypeVisitor9<String, Void>(this){
            final StringBuilder dimension = new StringBuilder("");

            @Override
            public String visitArray(ArrayType t, Void p) {
                this.dimension.append("[]");
                return (String)this.visit(t.getComponentType());
            }

            @Override
            protected String defaultAction(TypeMirror e, Void p) {
                return this.dimension.toString();
            }
        }.visit(type);
    }

    private AnnotationMirror getDeprecatedAnnotation(Element element) {
        List<? extends AnnotationMirror> annotationList = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationList) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            String qn = this.getFullyQualifiedName(annotationType.asElement(), true);
            if (!Strings.equal((String)qn, (String)Deprecated.class.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    @Override
    public boolean isDeprecated(Element element) {
        AnnotationMirror annotation = this.getDeprecatedAnnotation(element);
        return annotation != null;
    }

    @Override
    public boolean isDeprecatedForRemoval(Element element) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> pairs;
        AnnotationMirror annotation = this.getDeprecatedAnnotation(element);
        if (annotation != null && (pairs = annotation.getElementValues()) != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> elementEntry : pairs.entrySet()) {
                AnnotationValue value;
                if (elementEntry.getKey() == null || elementEntry.getValue() == null || !elementEntry.getKey().getSimpleName().contentEquals("forRemoval") || (value = elementEntry.getValue()) == null) continue;
                return Boolean.parseBoolean(value.toString());
            }
        }
        return false;
    }

    @Override
    public String getDeprecatedSince(Element element) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> pairs;
        AnnotationMirror annotation = this.getDeprecatedAnnotation(element);
        if (annotation != null && (pairs = annotation.getElementValues()) != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> elementEntry : pairs.entrySet()) {
                Object rvalue;
                AnnotationValue value;
                if (elementEntry.getKey() == null || elementEntry.getValue() == null || !elementEntry.getKey().getSimpleName().contentEquals("since") || (value = elementEntry.getValue()) == null || (rvalue = value.getValue()) == null) continue;
                String str = rvalue.toString();
                if (str.isEmpty()) {
                    return null;
                }
                return str;
            }
        }
        return null;
    }

    @Override
    public Element getFirstEnclosingDeprecatedElement(Element element) {
        Element current = element;
        do {
            if (!this.elementUtils.isDeprecated(current)) continue;
            return current;
        } while ((current = current.getEnclosingElement()) != null);
        return null;
    }

    @Override
    public boolean isExecutableElement(Element element) {
        ElementKind kind = element.getKind();
        switch (kind) {
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case METHOD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isVariableElement(Element element) {
        ElementKind kind = element.getKind();
        switch (kind) {
            case ENUM_CONSTANT: 
            case EXCEPTION_PARAMETER: 
            case FIELD: 
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case RESOURCE_VARIABLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPackage(Element element) {
        ElementKind kind = element.getKind();
        return kind == ElementKind.PACKAGE;
    }

    @Override
    public boolean isConstructor(Element element) {
        ElementKind kind = element.getKind();
        return kind == ElementKind.CONSTRUCTOR;
    }

    @Override
    public TypeElement getEnclosingTypeElement(Element executable) {
        Element elt;
        for (elt = executable.getEnclosingElement(); elt != null && !(elt instanceof TypeElement); elt = elt.getEnclosingElement()) {
        }
        if (elt instanceof TypeElement) {
            TypeElement cvalue = (TypeElement)elt;
            return cvalue;
        }
        return null;
    }

    @Override
    public boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    @Override
    public boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean isTypeElement(Element element) {
        switch (element.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPrivateAPI(Element element) {
        List<? extends AnnotationMirror> annotationList = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationList) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            String qn = this.getFullyQualifiedName(annotationType.asElement(), true);
            if (!Strings.equal((String)qn, (String)PrivateAPI.class.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> pairs = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> valueEntry : pairs.entrySet()) {
                AnnotationValue pvalue;
                if (valueEntry.getKey() == null || !valueEntry.getKey().getSimpleName().contentEquals("isCallerOnly") || (pvalue = valueEntry.getValue()) == null) continue;
                return !Boolean.parseBoolean(pvalue.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public TypeElement getReferencedClass(DocTree dtree, TypeMirror currentType, QualifiedNameSetBuilder findQualifiedNames) {
        Element e = this.getReferencedElement(dtree, currentType, findQualifiedNames);
        if (e == null) {
            return null;
        }
        if (this.isTypeElement(e)) {
            return (TypeElement)e;
        }
        if (!this.isPackage(e)) {
            return this.getEnclosingTypeElement(e);
        }
        return null;
    }

    @Override
    public Element getReferencedMember(DocTree dtree, TypeMirror currentType, QualifiedNameSetBuilder findQualifiedNames) {
        Element e = this.getReferencedElement(dtree, currentType, findQualifiedNames);
        if (e == null) {
            return null;
        }
        return this.isExecutableElement(e) || this.isVariableElement(e) ? e : null;
    }

    @Override
    public Element getReferencedElement(DocTree documentation, final TypeMirror currentType, final QualifiedNameSetBuilder findQualifiedNames) {
        return (Element)new SimpleDocTreeVisitor<Element, Void>(){

            @Override
            public Element visitSee(SeeTree node, Void p) {
                Iterator<? extends DocTree> iterator = node.getReference().iterator();
                if (iterator.hasNext()) {
                    DocTree dt = iterator.next();
                    return (Element)this.visit(dt, null);
                }
                return null;
            }

            @Override
            public Element visitLink(LinkTree node, Void p) {
                return (Element)this.visit(node.getReference(), null);
            }

            @Override
            public Element visitProvides(ProvidesTree node, Void p) {
                return (Element)this.visit(node.getServiceType(), null);
            }

            @Override
            public Element visitValue(ValueTree node, Void p) {
                return (Element)this.visit(node.getReference(), null);
            }

            @Override
            public Element visitReference(ReferenceTree node, Void p) {
                return ElementUtilsImpl.this.getElement(node, currentType, findQualifiedNames);
            }

            @Override
            public Element visitSerialField(SerialFieldTree node, Void p) {
                return (Element)this.visit(node.getType(), null);
            }

            @Override
            public Element visitUses(UsesTree node, Void p) {
                return (Element)this.visit(node.getServiceType(), null);
            }

            @Override
            protected Element defaultAction(DocTree node, Void p) {
                return null;
            }
        }.visit(documentation, null);
    }

    protected Element getElement(ReferenceTree rtree, TypeMirror currentType, QualifiedNameSetBuilder findQualifiedNames) {
        String componentName;
        String typeName;
        String signature = rtree.getSignature();
        int componentIndex = signature.indexOf(35);
        if (componentIndex >= 0) {
            typeName = signature.substring(0, componentIndex);
            componentName = signature.substring(componentIndex + 1);
        } else {
            typeName = signature;
            componentName = null;
        }
        TypeMirror typeMirror = !Strings.isEmpty((String)typeName) ? this.getSymbol(typeName, findQualifiedNames) : currentType;
        if (typeMirror != null) {
            Element element = this.typeUtils.asElement(typeMirror);
            if (element instanceof TypeElement && !Strings.isEmpty((String)componentName)) {
                String[] params;
                String sname;
                Matcher matcher = MEMBER_NAME_PATTERN.matcher(componentName);
                if (matcher.matches()) {
                    sname = matcher.group(1);
                    String p = matcher.group(2);
                    params = !Strings.isEmpty((String)p) ? p.split("\\s*,\\s*") : null;
                } else {
                    sname = componentName;
                    params = null;
                }
                assert (sname != null);
                if (sname.equals(element.getSimpleName().toString())) {
                    for (Element element2 : element.getEnclosedElements()) {
                        if (!this.isConstructor(element2)) continue;
                        ExecutableElement executableElement = (ExecutableElement)element2;
                        if (params == null || params.length == 0) {
                            if (executableElement.getParameters().size() != 0) continue;
                            return executableElement;
                        }
                        if (!this.areSameParams(params, executableElement.getParameters())) continue;
                        return element2;
                    }
                } else {
                    TreeSet treated = new TreeSet(this.getTypeMirrorComparator());
                    LinkedList<? extends TypeMirror> linkedList = new LinkedList<TypeMirror>();
                    linkedList.addLast(element.asType());
                    while (!linkedList.isEmpty()) {
                        TypeElement m1;
                        TypeMirror m0 = (TypeMirror)linkedList.removeFirst();
                        if (!treated.add(m0) || (m1 = this.asTypeElement(m0, this.typeUtils)) == null) continue;
                        for (Element element3 : m1.getEnclosedElements()) {
                            if (!Strings.equal((String)element3.getSimpleName().toString(), (String)sname)) continue;
                            if (this.isExecutableElement(element3)) {
                                ExecutableElement executableElement = (ExecutableElement)element3;
                                if (params == null || params.length == 0) {
                                    if (executableElement.getParameters().size() != 0) continue;
                                    return executableElement;
                                }
                                if (!this.areSameParams(params, executableElement.getParameters())) continue;
                                return element3;
                            }
                            if (!this.isVariableElement(element3)) continue;
                            return element3;
                        }
                        linkedList.add(m1.getSuperclass());
                        linkedList.addAll(m1.getInterfaces());
                    }
                }
                return null;
            }
            return element;
        }
        return null;
    }

    private static boolean isSameTypename(String qualifiedName, String name) {
        String n1;
        String n0 = qualifiedName.endsWith("...") ? qualifiedName.replaceFirst("\\.\\.\\.$", "[]") : qualifiedName;
        return Strings.equal((String)n0, (String)(n1 = name.endsWith("...") ? name.replaceFirst("\\.\\.\\.$", "[]") : name)) || n0.endsWith("." + n1);
    }

    private boolean areSameParams(String[] expected, List<? extends VariableElement> actual) {
        if (expected.length == actual.size()) {
            for (int i = 0; i < expected.length; ++i) {
                String etype;
                TypeMirror paramType = actual.get(i).asType();
                String atype = this.getFullIdentifier(paramType);
                if (ElementUtilsImpl.isSameTypename(atype, etype = expected[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public <T extends ExecutableElement> Comparator<? super T> getExecutableElementComparator() {
        return this.executableComparator;
    }

    @Override
    public <T extends ModuleElement> Comparator<? super T> getModuleElementComparator() {
        return this.moduleElementComparator;
    }

    @Override
    public <T extends PackageElement> Comparator<? super T> getPackageElementComparator() {
        return this.packageElementComparator;
    }

    @Override
    public <T extends TypeElement> Comparator<? super T> getTypeElementComparator() {
        return this.typeElementComparator;
    }

    @Override
    public <T extends TypeElement> Comparator<? super T> getTypeElementBasenameComparator() {
        return this.typeElementBasenameComparator;
    }

    @Override
    public <T extends TypeMirror> Comparator<? super T> getTypeMirrorComparator() {
        return this.typeMirrorComparator;
    }

    @Override
    public <T extends VariableElement> Comparator<? super T> getVariableElementComparator() {
        return this.variableComparator;
    }

    @Override
    public boolean isEventHandlerContainer(TypeElement element) {
        TypeMirror tm;
        if (element != null && element.getKind() == ElementKind.CLASS && (tm = element.asType()) != null) {
            return this.typeUtils.isAssignable(tm, this.getAgentType()) || this.typeUtils.isAssignable(tm, this.getSkillType()) || this.typeUtils.isAssignable(tm, this.getBehaviorType());
        }
        return false;
    }

    @Override
    public boolean isCapacityUser(TypeElement element) {
        TypeMirror tm;
        if (element != null && element.getKind() == ElementKind.CLASS && (tm = element.asType()) != null) {
            return this.typeUtils.isAssignable(tm, this.getAgentType()) || this.typeUtils.isAssignable(tm, this.getSkillType()) || this.typeUtils.isAssignable(tm, this.getBehaviorType());
        }
        return false;
    }

    @Override
    public boolean isSarlAgent(TypeElement type) {
        TypeMirror tm;
        if (type != null && type.getKind() == ElementKind.CLASS && (tm = type.asType()) != null) {
            return this.typeUtils.isAssignable(tm, this.getAgentType());
        }
        return false;
    }

    @Override
    public boolean isSarlBehavior(TypeElement type) {
        TypeMirror tm;
        if (type != null && type.getKind() == ElementKind.CLASS && (tm = type.asType()) != null) {
            return this.typeUtils.isAssignable(tm, this.getBehaviorType());
        }
        return false;
    }

    @Override
    public boolean isSarlCapacity(TypeElement type) {
        TypeMirror tm;
        if (type != null && type.getKind() == ElementKind.INTERFACE && (tm = type.asType()) != null) {
            return this.typeUtils.isAssignable(tm, this.getCapacityType());
        }
        return false;
    }

    @Override
    public boolean isSarlSkill(TypeElement type) {
        TypeMirror tm;
        if (type != null && type.getKind() == ElementKind.CLASS && (tm = type.asType()) != null) {
            return this.typeUtils.isAssignable(tm, this.getSkillType());
        }
        return false;
    }

    @Override
    public boolean isSarlEvent(TypeElement type) {
        TypeMirror tm;
        if (type != null && type.getKind() == ElementKind.CLASS && (tm = type.asType()) != null) {
            return this.typeUtils.isAssignable(tm, this.getEventType());
        }
        return false;
    }
}

