/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.framework.ExternalLinkManager;
import io.sarl.docs.doclet2.framework.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class ExternalLinkManagerImpl
implements ExternalLinkManager {
    private static final String MODULE_PREFIX = "module:";
    private static final String PACKAGE_LIST_NAME = "package-list";
    private static final String ELEMENT_LIST_NAME = "element-list";
    private ElementUtils elementUtils;
    private Set<URI> externalUrls = new HashSet<URI>();
    private Map<String, Item> externalModules;
    private Map<String, Map<String, Item>> externalPackages;

    protected void synchronizeExternalLinks(ExternalLinkManager.ExternalLinkManagerContext context) {
        if (this.externalModules == null || this.externalPackages == null) {
            this.externalModules = new TreeMap<String, Item>();
            this.externalPackages = new TreeMap<String, Map<String, Item>>();
            for (URI uri : this.getExternalLinks()) {
                InputStream is;
                URL url;
                context.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.ExternalLinkManagerImpl_0, uri.toASCIIString()));
                boolean read = true;
                try {
                    url = uri.resolve(ELEMENT_LIST_NAME).toURL();
                    is = url.openStream();
                    try {
                        this.readElementList(is, uri, context);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (IOException exception) {
                    read = false;
                    context.getReporter().print(Diagnostic.Kind.WARNING, MessageFormat.format(Messages.ExternalLinkManagerImpl_3, ELEMENT_LIST_NAME, exception.getLocalizedMessage()));
                }
                try {
                    url = uri.resolve(PACKAGE_LIST_NAME).toURL();
                    is = url.openStream();
                    try {
                        this.readElementList(is, uri, context);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException exception) {
                    if (read) continue;
                    context.getReporter().print(Diagnostic.Kind.WARNING, MessageFormat.format(Messages.ExternalLinkManagerImpl_3, PACKAGE_LIST_NAME, exception.getLocalizedMessage()));
                }
            }
        }
    }

    protected void readElementList(InputStream input, URI path, ExternalLinkManager.ExternalLinkManagerContext context) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(input));){
            String moduleName = null;
            String elementName = in.readLine();
            while (elementName != null) {
                if (!elementName.isBlank()) {
                    if (elementName.startsWith(MODULE_PREFIX)) {
                        moduleName = elementName.replace(MODULE_PREFIX, "");
                        URI fixedPath = path.resolve("/");
                        Item item = new Item(moduleName, fixedPath);
                        this.externalModules.put(moduleName, item);
                    } else {
                        URI elementPath;
                        String packagePath = elementName.replace('.', '/');
                        if (moduleName != null && !moduleName.isBlank()) {
                            URI moduleUri = path.resolve(moduleName + "/");
                            elementPath = moduleUri.resolve(packagePath + "/");
                        } else {
                            elementPath = path.resolve(packagePath + "/");
                        }
                        String actualModuleName = this.checkLinkCompatibility(elementName, moduleName, path, context);
                        Item item = new Item(elementName, elementPath);
                        this.externalPackages.computeIfAbsent(actualModuleName, k -> new TreeMap()).put(elementName, item);
                    }
                }
                elementName = in.readLine();
            }
        }
    }

    private String checkLinkCompatibility(String packageName, String moduleName, URI path, ExternalLinkManager.ExternalLinkManagerContext context) {
        PackageElement packageElement = context.getEnvironment().getElementUtils().getPackageElement(packageName);
        if (packageElement != null) {
            ModuleElement moduleElement = (ModuleElement)packageElement.getEnclosingElement();
            if (moduleElement == null || moduleElement.isUnnamed()) {
                if (moduleName != null) {
                    context.getReporter().print(Diagnostic.Kind.WARNING, MessageFormat.format(Messages.ExternalLinkManagerImpl_1, path.toASCIIString()));
                }
                return "<Unnamed>";
            }
            if (moduleName == null) {
                if (!this.isAutomaticModule(moduleElement)) {
                    context.getReporter().print(Diagnostic.Kind.WARNING, MessageFormat.format(Messages.ExternalLinkManagerImpl_2, path.toASCIIString()));
                }
                return moduleElement.getQualifiedName().toString();
            }
        }
        return moduleName == null ? "<Unnamed>" : moduleName;
    }

    private boolean isAutomaticModule(ModuleElement moduleElement) {
        if (moduleElement == null) {
            return false;
        }
        return false;
    }

    @Inject
    public void setElementUtils(ElementUtils utils) {
        this.elementUtils = utils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public Set<URI> getExternalLinks() {
        return Collections.unmodifiableSet(this.externalUrls);
    }

    @Override
    public void addExternalLink(URI uri) {
        assert (uri != null);
        if (this.externalUrls.add(uri)) {
            this.externalModules = null;
            this.externalPackages = null;
        }
    }

    @Override
    public void addExternalLink(URL url) {
        assert (url != null);
        try {
            URI uri = url.toURI();
            this.addExternalLink(uri);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public URI getExternalLink(Element element, String anchorName, ExternalLinkManager.ExternalLinkManagerContext context) {
        URI fullUri;
        if (context.getDocletOptions().isOffline()) {
            return null;
        }
        Item item = this.getCachedItem(element, context);
        if (item == null) {
            return null;
        }
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            fullUri = item.path.resolve(String.valueOf(typeElement.getSimpleName()) + ".html");
        } else {
            fullUri = item.path;
        }
        if (fullUri != null && !Strings.isNullOrEmpty((String)anchorName)) {
            try {
                String anchorName0 = URLEncoder.encode(anchorName, Charset.defaultCharset().displayName());
                String completedUri = fullUri.toString() + "#" + anchorName0;
                return URI.create(completedUri);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return fullUri;
    }

    protected Item getCachedItem(Element element, ExternalLinkManager.ExternalLinkManagerContext context) {
        Item item = null;
        if (this.getElementUtils().isExternal(element, context.getEnvironment())) {
            this.synchronizeExternalLinks(context);
            if (element instanceof ModuleElement) {
                ModuleElement moduleElement = (ModuleElement)element;
                item = this.externalModules.get(this.getElementUtils().getElementName(moduleElement));
            } else if (element instanceof PackageElement) {
                PackageElement packageElement = (PackageElement)element;
                ModuleElement moduleElement = context.getEnvironment().getElementUtils().getModuleOf(packageElement);
                Map<String, Item> packageMap = this.externalPackages.get(this.getElementUtils().getElementName(moduleElement));
                item = packageMap != null ? packageMap.get(this.getElementUtils().getElementName(packageElement)) : null;
            } else if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                PackageElement packageElement = context.getEnvironment().getElementUtils().getPackageOf(typeElement);
                ModuleElement moduleElement = context.getEnvironment().getElementUtils().getModuleOf(packageElement);
                Map<String, Item> packageMap = this.externalPackages.get(this.getElementUtils().getElementName(moduleElement));
                item = packageMap != null ? packageMap.get(this.getElementUtils().getElementName(packageElement)) : null;
            }
        }
        return item;
    }

    public static class Item {
        public final String name;
        public final URI path;

        public Item(String name, URI path) {
            this.name = name;
            this.path = path;
        }
    }
}

