/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import io.sarl.docs.doclet2.framework.QualifiedNameSetBuilder;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.PackageElement;
import org.eclipse.xtext.util.Strings;

public class StandardQualifiedNameSetBuilder
implements QualifiedNameSetBuilder {
    private final PackageElement currentPackage;
    private final Set<String> importedPackages;

    public StandardQualifiedNameSetBuilder(PackageElement currentPackage, Set<String> importedPackages) {
        this.currentPackage = currentPackage;
        this.importedPackages = importedPackages;
    }

    private static String qualifiedName(String packageName, String elementName) {
        if (Strings.isEmpty((String)packageName)) {
            return elementName;
        }
        return packageName + "." + elementName;
    }

    @Override
    public Set<String> buildCandidateList(String basename) {
        LinkedHashSet<String> candidates = new LinkedHashSet<String>(this.importedPackages.size() + 3);
        for (String importedPkg : this.importedPackages) {
            candidates.add(StandardQualifiedNameSetBuilder.qualifiedName(importedPkg, basename));
        }
        candidates.add(StandardQualifiedNameSetBuilder.qualifiedName(this.currentPackage.getQualifiedName().toString(), basename));
        candidates.add(StandardQualifiedNameSetBuilder.qualifiedName(String.class.getPackageName(), basename));
        return candidates;
    }
}

