/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import io.sarl.docs.doclet2.framework.TagletManager;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Taglet;

public class TagletManagerImpl
implements TagletManager {
    private final Map<String, Taglet> allTaglets = new TreeMap<String, Taglet>();
    private Map<Taglet.Location, Set<String>> blockTagletsByLocation = new TreeMap<Taglet.Location, Set<String>>();
    private final Set<String> inlineTags = new TreeSet<String>();
    private WeakReference<DocletEnvironment> environment;
    private WeakReference<Doclet> doclet;

    private static String unifyId(String name) {
        return name.toLowerCase();
    }

    @Override
    public synchronized void addTaglet(Taglet taglet, boolean override) {
        boolean doAddition;
        String uname = TagletManagerImpl.unifyId(taglet.getName());
        if (override) {
            doAddition = true;
        } else {
            boolean bl = doAddition = !this.allTaglets.containsKey(uname);
        }
        if (doAddition) {
            this.addTaglet(uname, taglet);
        }
    }

    protected void addTaglet(String uname, Taglet taglet) {
        try {
            DocletEnvironment env;
            this.allTaglets.put(uname, taglet);
            if (taglet.isInlineTag()) {
                this.inlineTags.add(uname);
            } else {
                for (Taglet.Location loc : taglet.getAllowedLocations()) {
                    Set list = this.blockTagletsByLocation.computeIfAbsent(loc, it -> new TreeSet());
                    list.add(uname);
                }
            }
            DocletEnvironment docletEnvironment = env = this.environment == null ? null : (DocletEnvironment)this.environment.get();
            if (env != null) {
                Doclet doclet = this.doclet == null ? null : (Doclet)this.doclet.get();
                taglet.init(env, doclet);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Taglet getBlockTaglet(Taglet.Location location, String name) {
        Set<String> theset;
        String uname = TagletManagerImpl.unifyId(name);
        Taglet taglet = this.allTaglets.get(uname);
        if (taglet != null && (theset = this.blockTagletsByLocation.get((Object)location)) != null && theset.contains(uname)) {
            return taglet;
        }
        return null;
    }

    @Override
    public synchronized Taglet getInlineTaglet(String name) {
        String uname = TagletManagerImpl.unifyId(name);
        Taglet taglet = this.allTaglets.get(uname);
        if (taglet != null && this.inlineTags.contains(uname)) {
            return taglet;
        }
        return null;
    }

    @Override
    public synchronized Collection<Taglet> getAllTaglets() {
        return Collections.unmodifiableCollection(this.allTaglets.values());
    }

    @Override
    public synchronized void init(DocletEnvironment environment, Doclet doclet) {
        this.environment = new WeakReference<DocletEnvironment>(environment);
        this.doclet = new WeakReference<Doclet>(doclet);
        for (Taglet taglet : this.getAllTaglets()) {
            taglet.init(environment, doclet);
        }
    }
}

